/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.tasks.io;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import net.coobird.thumbnailator.geometry.Region;
import net.coobird.thumbnailator.tasks.io.AbstractImageSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedImageSource
extends AbstractImageSource<BufferedImage> {
    private final BufferedImage img;

    public BufferedImageSource(BufferedImage img) {
        if (img == null) {
            throw new NullPointerException("Image cannot be null.");
        }
        this.img = img;
    }

    @Override
    public BufferedImage read() throws IOException {
        this.inputFormatName = null;
        if (this.param != null && this.param.getSourceRegion() != null) {
            Region region = this.param.getSourceRegion();
            Rectangle r = region.calculate(this.img.getWidth(), this.img.getHeight());
            return this.finishedReading(this.img.getSubimage(r.x, r.y, r.width, r.height));
        }
        return this.finishedReading(this.img);
    }

    @Override
    public BufferedImage getSource() {
        return this.img;
    }
}

