/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.xmind.ui.dialogs.Messages;
import org.xmind.ui.dialogs.Polygon;
import org.xmind.ui.dialogs.StyledLink;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

public class NotificationWindow
extends Window {
    private static final int DEFAULT_WIDTH = 260;
    private static final int MARGIN = 15;
    private static final int TWO_MARGINS = 30;
    private static final int CORNER = 19;
    private static final int SPACING = 15;
    private static final int DEFAULT_DURATION = 30000;
    private static final int FINAL_ALPHA = 200;
    private static final int AUTO_FADE_OUT_DURATION = 4000;
    private static final int HOVER_FADE_IN_DURATION = 600;
    private static final Map<Monitor, List<NotificationWindow>> TRAILING_DIALOGS = new HashMap<Monitor, List<NotificationWindow>>(2);
    private Shell sourceShell;
    private String title;
    private IAction action;
    private IAction moreAction;
    private int duration;
    private Region shape = null;
    private long startTime = 0L;
    private boolean showing = false;
    private boolean closing = false;
    private boolean hovered = false;
    private Control closeButton = null;
    private boolean closeOnMoreLink = false;

    public NotificationWindow(Shell sourceShell, String title, IAction action, IAction moreAction, int duration) {
        super(null);
        this.title = title;
        Assert.isNotNull((Object)action);
        this.sourceShell = sourceShell;
        this.action = action;
        this.moreAction = moreAction;
        this.duration = duration < 0 ? 30000 : duration;
        this.setBlockOnOpen(false);
        this.setShellStyle(16392);
    }

    public NotificationWindow setCloseOnMoreLink(boolean closeOnMoreLink) {
        this.closeOnMoreLink = closeOnMoreLink;
        return this;
    }

    protected void constrainShellSize() {
        Shell trailingShell;
        Monitor monitor = this.sourceShell == null || this.sourceShell.isDisposed() ? Display.getCurrent().getPrimaryMonitor() : this.sourceShell.getMonitor();
        Rectangle clientArea = monitor.getClientArea();
        Shell shell = this.getShell();
        Point contentsSize = this.getContents().computeSize(260, -1, true);
        Rectangle result = shell.computeTrim(0, 0, contentsSize.x + 30, contentsSize.y + 30);
        List<NotificationWindow> dialogs = TRAILING_DIALOGS.get(monitor);
        if (dialogs == null) {
            dialogs = new ArrayList<NotificationWindow>(10);
            TRAILING_DIALOGS.put(monitor, dialogs);
        }
        result = (trailingShell = this.findLastShell(dialogs)) != null && !trailingShell.isDisposed() ? this.computeNewLocation(clientArea, result, trailingShell.getBounds()) : this.computeNewLocation(clientArea, result);
        shell.setBounds(result);
        dialogs.remove((Object)this);
        dialogs.add(this);
        if (this.shape == null || this.shape.isDisposed()) {
            this.shape = this.createShape(shell, result);
        }
        shell.setRegion(this.shape);
    }

    private Shell findLastShell(List<NotificationWindow> dialogs) {
        int i = dialogs.size() - 1;
        while (i >= 0) {
            NotificationWindow dialog = dialogs.get(i);
            Shell lastShell = dialog.getShell();
            if (lastShell != null && !lastShell.isDisposed()) {
                return lastShell;
            }
            dialogs.remove(i);
            --i;
        }
        return null;
    }

    private Rectangle computeNewLocation(Rectangle clientArea, Rectangle size, Rectangle lastBounds) {
        int newY = lastBounds.y + lastBounds.height + 15;
        if (newY + size.height < clientArea.y + clientArea.height) {
            return new Rectangle(lastBounds.x, newY, size.width, size.height);
        }
        int newX = lastBounds.x - 15 - size.width;
        if (newX > clientArea.x) {
            return new Rectangle(newX, clientArea.y + 15, size.width, size.height);
        }
        return this.computeNewLocation(clientArea, size);
    }

    private Rectangle computeNewLocation(Rectangle clientArea, Rectangle size) {
        return new Rectangle(clientArea.x + clientArea.width - 15 - size.width, clientArea.y + 15, size.width, size.height);
    }

    private Region createShape(Shell shell, Rectangle r) {
        int left = 0;
        int top = 0;
        int right = left + r.width;
        int bottom = top + r.height;
        Polygon polygon = new Polygon(250);
        polygon.lineTo(left + 19, top);
        polygon.lineTo(right, top);
        polygon.lineTo(right, bottom - 19);
        polygon.roundCornerTo(right, bottom, right - 19, bottom);
        polygon.lineTo(left, bottom);
        polygon.lineTo(left, top + 19);
        polygon.roundCornerTo(left, top, left + 19, top);
        final Region s = new Region((Device)shell.getDisplay());
        s.add(polygon.toPointList());
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                s.dispose();
            }
        });
        return s;
    }

    protected Layout getLayout() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        return layout;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 9;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createIconAndActions(composite);
        this.createCloseButton(parent);
        return composite;
    }

    private void createIconAndActions(Composite parent) {
        Image image = null;
        ImageDescriptor icon = this.action.getImageDescriptor();
        final Image imageToDispose = icon != null ? (image = icon.createImage(false)) : null;
        if (image == null && this.sourceShell != null && !this.sourceShell.isDisposed()) {
            image = this.findBrandingImage(this.sourceShell.getImage(), this.sourceShell.getImages());
        }
        if (image != null) {
            ((GridLayout)parent.getLayout()).numColumns = 2;
            Label iconLabel = new Label(parent, 0);
            iconLabel.setBackground(parent.getBackground());
            iconLabel.setForeground(parent.getForeground());
            iconLabel.setImage(image);
            iconLabel.setLayoutData((Object)new GridData(1, 1, false, true));
            Composite composite = new Composite(parent, 0);
            composite.setBackground(parent.getBackground());
            composite.setForeground(parent.getForeground());
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 9;
            layout.horizontalSpacing = 0;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            if (imageToDispose != null) {
                iconLabel.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        imageToDispose.dispose();
                    }
                });
            }
            parent = composite;
        }
        this.createActions(parent);
    }

    private Image findBrandingImage(Image mainImage, Image[] images) {
        int s;
        Rectangle r;
        Image best = null;
        int scale = -1;
        if (mainImage != null) {
            r = mainImage.getBounds();
            s = Math.abs(r.width - 48) * Math.abs(r.height - 48);
            if (scale < 0 || s < scale) {
                best = mainImage;
                scale = s;
            }
        }
        Image[] imageArray = images;
        int n = images.length;
        int n2 = 0;
        while (n2 < n) {
            Image img = imageArray[n2];
            r = img.getBounds();
            s = Math.abs(r.width - 48) * Math.abs(r.height - 48);
            if (scale < 0 || s < scale) {
                best = img;
                scale = s;
            }
            ++n2;
        }
        return best;
    }

    private void createActions(Composite parent) {
        this.createTitle(parent);
        this.createActionLink(parent);
        if (this.moreAction != null) {
            this.createMoreLink(parent);
        }
    }

    private void createTitle(Composite parent) {
        String text = Display.getAppName();
        if (text == null && this.title == null) {
            return;
        }
        if (text == null) {
            text = this.title;
        } else if (this.title != null) {
            text = String.valueOf(text) + " - " + this.title;
        }
        Label label = new Label(parent, 64);
        label.setText(text);
        label.setBackground(parent.getBackground());
        label.setForeground(parent.getForeground());
        label.setFont(FontUtils.getBoldRelative("org.eclipse.jface.defaultfont", 1));
        label.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    private void createActionLink(Composite parent) {
        String content = this.action.getText();
        StyledLink link = content.indexOf("<form>") >= 0 ? new StyledLink(parent, 0) : new StyledLink(parent, 64);
        link.setText(content);
        link.setBackground(parent.getBackground());
        link.setForeground(parent.getForeground());
        link.setEnabled(this.action.isEnabled());
        link.setFont(FontUtils.getRelativeHeight("org.eclipse.jface.defaultfont", Util.isMac() ? -2 : -1));
        link.setLayoutData(new GridData(4, 4, true, true));
        final IAction theAction = this.action;
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NotificationWindow.this.close();
                        theAction.run();
                    }
                });
            }
        });
    }

    private void createMoreLink(Composite parent) {
        String moreText = this.moreAction.getText();
        if (moreText == null) {
            moreText = Messages.NotificationDialog_MoreLink_defaultText;
        }
        StyledLink link = new StyledLink(parent, 64);
        link.setText(moreText);
        link.setFont(FontUtils.getRelativeHeight("org.eclipse.jface.defaultfont", -2));
        link.setBackground(parent.getBackground());
        link.setForeground(ColorUtils.getColor(80, 100, 250));
        link.setEnabled(this.moreAction.isEnabled());
        link.setLayoutData(new GridData(4, 0x1000000, true, false));
        final IAction theMoreAction = this.moreAction;
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (NotificationWindow.this.closeOnMoreLink) {
                            NotificationWindow.this.close();
                        }
                        theMoreAction.run();
                    }
                });
            }
        });
    }

    private void createCloseButton(Composite parent) {
        Label label = new Label(parent, 0);
        this.closeButton = label;
        label.setBackground(ColorUtils.getColor(8, 8, 8));
        label.setForeground(parent.getForeground());
        GridData layoutData = new GridData(1, 1, false, false);
        layoutData.exclude = true;
        label.setLayoutData((Object)layoutData);
        label.setSize(32, 32);
        label.setLocation(0, 0);
        label.setCursor(parent.getDisplay().getSystemCursor(21));
        label.moveAbove(null);
        label.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                gc.setAntialias(1);
                gc.setLineStyle(1);
                gc.setLineJoin(2);
                gc.setLineWidth(1);
                gc.fillRectangle(0, 0, 32, 32);
                gc.setLineWidth(3);
                gc.drawArc(5, 5, 21, 21, 0, 360);
                int a = 11;
                int b = 20;
                gc.drawLine(a, a, b, b);
                gc.drawLine(a, b, b, a);
            }
        });
        Polygon polygon = new Polygon(250);
        int y1 = 4;
        int x1 = 4;
        int y2 = 16;
        int x2 = 16;
        int y3 = 28;
        int x3 = 28;
        polygon.lineTo(x2, y1);
        polygon.roundCornerTo(x3, y1, x3, y2);
        polygon.roundCornerTo(x3, y3, x2, y3);
        polygon.roundCornerTo(x1, y3, x1, y2);
        polygon.roundCornerTo(x1, y1, x2, y1);
        final Region region = new Region((Device)parent.getDisplay());
        region.add(polygon.toPointList());
        label.setRegion(region);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                region.dispose();
            }
        });
        label.setVisible(false);
        label.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                event.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NotificationWindow.this.close();
                    }
                });
            }
        });
    }

    private void toggleCloseButton(boolean visible) {
        if (this.closeButton != null && !this.closeButton.isDisposed()) {
            this.closeButton.setVisible(visible);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Display display = newShell.getDisplay();
        newShell.setBackground(display.getSystemColor(2));
        newShell.setForeground(display.getSystemColor(1));
        newShell.setAlpha(200);
    }

    public void create() {
        super.create();
        final Shell shell = this.getShell();
        Listener mouseTracker = new Listener(){

            public void handleEvent(Event event) {
                if (shell.isDisposed()) {
                    return;
                }
                Point p = ((Control)event.widget).toDisplay(event.x, event.y);
                if (shell.getBounds().contains(p)) {
                    if (NotificationWindow.this.closing) {
                        return;
                    }
                    NotificationWindow.this.hovered = true;
                    NotificationWindow.this.toggleCloseButton(true);
                    if (!NotificationWindow.this.showing && shell.getAlpha() < 200) {
                        NotificationWindow.this.showing = true;
                        NotificationWindow.this.fadeTo(200, 600, new Runnable(){

                            @Override
                            public void run() {
                                NotificationWindow.this.showing = false;
                                NotificationWindow.this.countDown(5000);
                            }
                        });
                    }
                } else {
                    NotificationWindow.this.hovered = false;
                    NotificationWindow.this.toggleCloseButton(false);
                }
            }
        };
        this.trackMouseMove((Control)shell, mouseTracker);
    }

    private void trackMouseMove(Control c, Listener mouseTracker) {
        c.addListener(7, mouseTracker);
        c.addListener(6, mouseTracker);
        if (c instanceof Composite) {
            Control[] controlArray = ((Composite)c).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.trackMouseMove(child, mouseTracker);
                ++n2;
            }
        }
    }

    private void fadeTo(final int finalAlpha, int defaultDuration, final Runnable callback) {
        long start;
        final Shell shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        final int startAlpha = shell.getAlpha();
        final int t = defaultDuration * 10 / 200;
        final int minAlpha = Math.min(startAlpha, finalAlpha);
        final int maxAlpha = Math.max(startAlpha, finalAlpha);
        final int[] step = new int[]{0};
        this.startTime = start = System.currentTimeMillis();
        Display.getCurrent().timerExec(1, new Runnable(){

            @Override
            public void run() {
                if (NotificationWindow.this.startTime != start) {
                    return;
                }
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                step[0] = finalAlpha > startAlpha ? step[0] + 10 : step[0] - 10;
                int newAlpha = startAlpha + step[0] / t;
                if (newAlpha > maxAlpha || newAlpha < minAlpha) {
                    if (callback != null) {
                        callback.run();
                    }
                } else {
                    if (newAlpha != shell.getAlpha()) {
                        shell.setAlpha(newAlpha);
                    }
                    Display.getCurrent().timerExec(1, (Runnable)this);
                }
            }
        });
    }

    public int open() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            this.create();
        }
        this.constrainShellSize();
        this.getShell().setVisible(true);
        this.showing = true;
        this.closing = false;
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                NotificationWindow.this.countDown(NotificationWindow.this.duration);
            }
        });
        return 0;
    }

    public boolean close() {
        this.closing = true;
        this.hovered = false;
        this.showing = false;
        this.hardClose();
        return true;
    }

    private void hardClose() {
        super.close();
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.dispose();
        }
    }

    private void countDown(int duration) {
        long countDownTime;
        if (duration == 0) {
            return;
        }
        this.startTime = countDownTime = System.currentTimeMillis();
        Display.getCurrent().timerExec(duration, new Runnable(){

            @Override
            public void run() {
                if (NotificationWindow.this.startTime != countDownTime) {
                    return;
                }
                if (NotificationWindow.this.hovered) {
                    Display.getCurrent().timerExec(1000, (Runnable)this);
                } else {
                    NotificationWindow.this.fadeTo(0, 4000, new Runnable(){

                        @Override
                        public void run() {
                            NotificationWindow.this.hardClose();
                        }
                    });
                }
            }
        });
    }

    public static void main(String[] args) {
        Display.setAppName((String)"Main");
        Display display = new Display();
        try {
            Action action = new Action(){

                public void run() {
                    super.run();
                    System.out.println("Action clicked.");
                }
            };
            action.setText("<form><p>Test <b>test</b>  test test\n test test test test waf awoijf oa&amp;wfoaw <b><i>foaawefwfewfawj</i></b> foaw fo awof aw.</p><p>&quot;WOfjsiowf&quot; s fowe &#x6587;&#x5B57; ofwjfosj</p></form>");
            action.setImageDescriptor(ImageDescriptor.createFromImage((Image)display.getSystemImage(2)));
            action.setEnabled(true);
            Action action2 = new Action(){

                public void run() {
                    System.out.println("Simple action clicked.");
                }
            };
            action2.setText("File has been downloaded:\nC:\\Users\\USER\\Download\\test.xmind\r\nXMind test test test aowif waof awiof jawiofaj wiofaowfjawoifjaw ofawoifjaowf aowe jfoaw.");
            Action moreAction = new Action(){

                public void run() {
                    super.run();
                    System.out.println("More clicked.");
                }
            };
            moreAction.setText("Details...");
            new NotificationWindow(null, "XMind", (IAction)action, null, -1).open();
            new NotificationWindow(null, "Test Notification", (IAction)action, (IAction)moreAction, -1).open();
            new NotificationWindow(null, null, (IAction)action, null, 4000).open();
            new NotificationWindow(null, null, (IAction)action2, (IAction)moreAction, -1).open();
            new NotificationWindow(null, null, (IAction)action2, null, 10000).open();
            Shell shell = new Shell(display);
            shell.setSize(400, 300);
            Button addButton = new Button((Composite)shell, 8);
            addButton.setText("Add");
            addButton.setSize(100, addButton.computeSize((int)-1, (int)-1, (boolean)true).y);
            addButton.setLocation(10, 10);
            addButton.addListener(13, new Listener((IAction)action, (IAction)moreAction){
                private final /* synthetic */ IAction val$action;
                private final /* synthetic */ IAction val$moreAction;
                {
                    this.val$action = iAction;
                    this.val$moreAction = iAction2;
                }

                public void handleEvent(Event event) {
                    new NotificationWindow(null, null, this.val$action, this.val$moreAction, -1).open();
                }
            });
            shell.open();
            while (!shell.isDisposed() && !display.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            shell.dispose();
        }
        finally {
            display.dispose();
        }
    }
}

