/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.EncodingUtils;

public class StyledLink
extends Canvas {
    private static final int LINE_SPACING = 1;
    private static final int PARAGRAPH_SPACING = 7;
    private String text = "";
    private boolean styled;
    private StyledParagraph[] paragraphs = null;
    private int cachedWidth = -621735;
    private Point cachedSize = null;
    private boolean hovered = false;
    private Font boldFont = null;
    private Font italicFont = null;
    private Font boldItalicFont = null;
    private ListenerList listeners = new ListenerList();

    public StyledLink(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.styled = (style & 0x40) == 0;
        super.setFont(FontUtils.getFont("org.eclipse.jface.defaultfont"));
        super.setCursor(parent.getDisplay().getSystemCursor(21));
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                StyledLink.this.drawParagraphs(e.gc);
            }
        });
        this.addMouseListener(new MouseListener(){
            boolean pressed = false;

            public void mouseUp(MouseEvent e) {
                Rectangle r = StyledLink.this.getBounds();
                if (this.pressed && e.x >= 0 && e.x < r.width && e.y >= 0 && e.y < r.height) {
                    StyledLink.this.fireLinkActivated(StyledLink.this.createLinkEvent(e));
                }
                this.pressed = false;
            }

            public void mouseDown(MouseEvent e) {
                this.pressed = true;
            }

            public void mouseDoubleClick(MouseEvent e) {
                this.pressed = false;
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                StyledLink.this.setHovered(true);
            }

            public void mouseExit(MouseEvent e) {
                StyledLink.this.setHovered(false);
            }

            public void mouseEnter(MouseEvent e) {
                StyledLink.this.setHovered(true);
            }
        });
    }

    private void fireLinkActivated(HyperlinkEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IHyperlinkListener)listener).linkActivated(event);
            ++n2;
        }
    }

    private HyperlinkEvent createLinkEvent(MouseEvent e) {
        HyperlinkEvent event = new HyperlinkEvent((Widget)this, null, this.getText(), e.stateMask);
        event.display = e.display;
        event.time = e.time;
        return event;
    }

    public void addHyperlinkListener(IHyperlinkListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeHyperlinkListener(IHyperlinkListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setFont(Font font) {
        this.checkWidget();
        this.releaseLines();
        super.setFont(font);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this.releaseLines();
        super.setBackground(color);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        this.releaseLines();
        super.setForeground(color);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.releaseLines();
        super.setEnabled(enabled);
    }

    private void releaseLines() {
        StyledParagraph[] ls = this.paragraphs;
        this.paragraphs = null;
        if (ls != null) {
            int i = 0;
            while (i < ls.length) {
                ls[i].text.dispose();
                ++i;
            }
        }
    }

    private void ensureParagraphs(int wHint) {
        if (this.paragraphs != null) {
            return;
        }
        this.paragraphs = this.styled ? this.parseStyledText(this.text, wHint) : this.parseSimpleText(this.text, wHint);
        this.cachedSize = new Point(0, 0);
        if (this.paragraphs.length == 0) {
            if (wHint >= 0) {
                this.cachedSize.x = wHint;
            }
        } else {
            StyledParagraph[] styledParagraphArray = this.paragraphs;
            int n = this.paragraphs.length;
            int n2 = 0;
            while (n2 < n) {
                StyledParagraph p = styledParagraphArray[n2];
                Rectangle pBounds = p.text.getBounds();
                this.cachedSize.x = Math.max(this.cachedSize.x, pBounds.width);
                this.cachedSize.y = p.top + pBounds.height;
                ++n2;
            }
        }
    }

    private StyledParagraph[] parseStyledText(String text, int wHint) {
        ArrayList<StyledParagraph> paragraphs = new ArrayList<StyledParagraph>(text.length() / 2);
        int contentStart = text.indexOf("<form>");
        if (contentStart >= 0) {
            int contentEnd = text.indexOf("</form>", contentStart += 6);
            if (contentEnd < 0) {
                contentEnd = text.length();
            }
            String content = text.substring(contentStart, contentEnd);
            int pStart = 0;
            int pEnd = 0;
            int top = 0;
            boolean bold = false;
            boolean italic = false;
            while (pStart < content.length()) {
                String pText;
                if ("<p>".equals(content.substring(pStart, pStart + 3))) {
                    pStart += 3;
                }
                if ((pEnd = content.indexOf("</p>", pStart)) >= 0) {
                    pText = content.substring(pStart, pEnd);
                    pEnd += 4;
                } else {
                    pEnd = content.indexOf("<p>", pStart);
                    if (pEnd >= 0) {
                        pText = content.substring(pStart, pEnd);
                        pEnd += 3;
                    } else {
                        pEnd = content.length();
                        pText = content.substring(pStart, pEnd);
                    }
                }
                pStart = pEnd;
                StringBuilder pBuffer = new StringBuilder(pText.length());
                ArrayList<StyleRange> styles = new ArrayList<StyleRange>(pText.length());
                int start = 0;
                int end = 0;
                while (start < pText.length()) {
                    if ("<b>".equals(pText.substring(start, start + 3))) {
                        bold = true;
                        start += 3;
                        continue;
                    }
                    if ("<i>".equals(pText.substring(start, start + 3))) {
                        italic = true;
                        start += 3;
                        continue;
                    }
                    if ("</b>".equals(pText.substring(start, start + 4))) {
                        bold = false;
                        start += 4;
                        continue;
                    }
                    if ("</i>".equals(pText.substring(start, start + 4))) {
                        italic = false;
                        start += 4;
                        continue;
                    }
                    if (pText.charAt(start) == '<') {
                        end = pText.indexOf(62, start + 1);
                        if (end < 0) {
                            end = pText.length();
                        }
                        start = ++end;
                        continue;
                    }
                    end = pText.indexOf(60, start);
                    if (end < 0) {
                        end = pText.length();
                    }
                    int styleStart = pBuffer.length();
                    pBuffer.append(this.unescape(pText.substring(start, end)));
                    int styleEnd = pBuffer.length();
                    styles.add(this.newStyleRange(bold, italic, styleStart, styleEnd));
                    start = end;
                }
                if (pBuffer.length() == 0) {
                    top += 7;
                    continue;
                }
                StyledParagraph paragraph = new StyledParagraph();
                paragraph.text = new TextLayout((Device)this.getDisplay());
                paragraph.text.setFont(this.getFont());
                paragraph.text.setAlignment(16384);
                paragraph.text.setSpacing(1);
                paragraph.text.setText(pBuffer.toString());
                for (StyleRange style : styles) {
                    paragraph.text.setStyle((TextStyle)style, style.start, style.start + style.length);
                }
                paragraph.text.setWidth(wHint);
                paragraph.top = top;
                paragraphs.add(paragraph);
                top += paragraph.text.getBounds().height + 7;
            }
        }
        return paragraphs.toArray(new StyledParagraph[paragraphs.size()]);
    }

    private StyledParagraph[] parseSimpleText(String text, int wHint) {
        ArrayList<StyledParagraph> paragraphs = new ArrayList<StyledParagraph>(text.length() / 2);
        int start = 0;
        int end = 0;
        int top = 0;
        while (start < text.length()) {
            if (text.charAt(start) == '\r') {
                start = start + 1 < text.length() && text.charAt(start + 1) == '\n' ? (start += 2) : ++start;
                top += 7;
                continue;
            }
            if (text.charAt(start) == '\n') {
                ++start;
                top += 7;
                continue;
            }
            end = Math.min(text.indexOf(10, start), text.indexOf(13, start));
            if (end < 0) {
                end = text.length();
            }
            if (end > start) {
                StyledParagraph paragraph = new StyledParagraph();
                paragraph.text = new TextLayout((Device)this.getDisplay());
                paragraph.text.setFont(this.getFont());
                paragraph.text.setAlignment(16384);
                paragraph.text.setSpacing(1);
                paragraph.text.setText(text.substring(start, end));
                paragraph.text.setStyle(this.newStyle(false, false), 0, end - start);
                paragraph.text.setWidth(wHint);
                paragraph.top = top;
                paragraphs.add(paragraph);
                top += paragraph.text.getBounds().height;
            }
            start = end;
        }
        return paragraphs.toArray(new StyledParagraph[paragraphs.size()]);
    }

    private String unescape(String text) {
        return EncodingUtils.unescape(text);
    }

    private StyleRange newStyleRange(boolean bold, boolean italic, int start, int end) {
        StyleRange style = new StyleRange();
        this.applyStyle((TextStyle)style, bold, italic);
        style.start = start;
        style.length = end - start;
        return style;
    }

    private TextStyle newStyle(boolean bold, boolean italic) {
        TextStyle style = new TextStyle();
        this.applyStyle(style, bold, italic);
        return style;
    }

    private void applyStyle(TextStyle style, boolean bold, boolean italic) {
        style.background = this.getBackground();
        style.foreground = this.getForeground();
        style.underline = this.isEnabled() && this.hovered;
        style.underlineColor = this.getForeground();
        style.underlineStyle = 4;
        style.strikeout = false;
        style.strikeoutColor = null;
        style.font = bold && italic ? this.getBoldItalicFont() : (bold ? this.getBoldFont() : (italic ? this.getItalicFont() : this.getFont()));
    }

    private Font getBoldFont() {
        if (this.boldFont == null) {
            this.boldFont = new Font((Device)this.getDisplay(), FontUtils.bold(this.getFont().getFontData(), true));
        }
        return this.boldFont;
    }

    private Font getItalicFont() {
        if (this.italicFont == null) {
            this.italicFont = new Font((Device)this.getDisplay(), FontUtils.italic(this.getFont().getFontData(), true));
        }
        return this.italicFont;
    }

    private Font getBoldItalicFont() {
        if (this.boldItalicFont == null) {
            this.boldItalicFont = new Font((Device)this.getDisplay(), FontUtils.bold(FontUtils.italic(this.getFont().getFontData(), true), true));
        }
        return this.boldItalicFont;
    }

    private void drawParagraphs(GC gc) {
        this.ensureParagraphs(this.cachedWidth);
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        StyledParagraph[] styledParagraphArray = this.paragraphs;
        int n = this.paragraphs.length;
        int n2 = 0;
        while (n2 < n) {
            StyledParagraph p = styledParagraphArray[n2];
            p.text.draw(gc, 0, p.top);
            ++n2;
        }
    }

    private void setHovered(boolean hovered) {
        boolean bl = hovered = hovered && this.isEnabled();
        if (hovered == this.hovered) {
            return;
        }
        this.hovered = hovered;
        this.releaseLines();
        this.redraw();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (changed || this.cachedWidth != wHint || this.paragraphs == null || this.cachedSize == null) {
            this.releaseLines();
            this.ensureParagraphs(wHint);
            this.cachedWidth = wHint;
        }
        return new Point(this.cachedSize.x, this.cachedSize.y);
    }

    public void dispose() {
        this.releaseLines();
        if (this.boldFont != null) {
            this.boldFont.dispose();
            this.boldFont = null;
        }
        if (this.italicFont != null) {
            this.italicFont.dispose();
            this.italicFont = null;
        }
        if (this.boldItalicFont != null) {
            this.boldItalicFont.dispose();
            this.boldItalicFont = null;
        }
        super.dispose();
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            SWT.error((int)4);
        }
        if (text.equals(this.text)) {
            return;
        }
        this.text = text;
        this.releaseLines();
        this.redraw();
    }

    public String getText() {
        return this.text;
    }

    private static class StyledParagraph {
        TextLayout text;
        int top;

        private StyledParagraph() {
        }
    }
}

