/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.resources;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ErrorImageDescriptor
extends ImageDescriptor {
    private int width;
    private int height;

    protected ErrorImageDescriptor(int width, int height) {
        this.width = Math.max(1, width);
        this.height = Math.max(1, height);
    }

    public ImageData getImageData() {
        Display device = Display.getCurrent();
        if (device == null) {
            return null;
        }
        Image img = new Image((Device)device, this.width, this.height);
        GC gc = new GC((Drawable)img);
        Color white = new Color((Device)device, 255, 255, 255);
        Color red = new Color((Device)device, 255, 0, 0);
        ImageData data = null;
        try {
            gc.setBackground(white);
            gc.fillRectangle(0, 0, this.width, this.height);
            int padding = Math.min(this.width, this.height);
            padding = padding < 8 ? 0 : (padding < 16 ? padding / 2 - 4 : 4);
            gc.setForeground(red);
            int w = this.width - 1;
            int h = this.height - 1;
            gc.drawRectangle(0, 0, w, h);
            gc.drawLine(padding, padding, w -= padding, h -= padding);
            gc.drawLine(padding, h, w, padding);
            data = img.getImageData();
            data.transparentPixel = data.palette.getPixel(new RGB(255, 255, 255));
        }
        finally {
            gc.dispose();
            img.dispose();
            white.dispose();
            red.dispose();
        }
        return data;
    }

    public String toString() {
        return "ErrorImageDescriptor(" + this.width + "," + this.height + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ErrorImageDescriptor)) {
            return false;
        }
        ErrorImageDescriptor that = (ErrorImageDescriptor)((Object)obj);
        return this.width == that.width && this.height == that.height;
    }

    public int hashCode() {
        return this.height ^ this.width;
    }
}

