/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;

public class PrefixedStorage
implements IStorage {
    private IStorage storage;
    private String prefix;

    public PrefixedStorage(IStorage storage, String prefix) {
        this.storage = storage;
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public IInputSource getInputSource() {
        return new PrefixedInputSource(this.storage.getInputSource());
    }

    public IOutputTarget getOutputTarget() {
        return new PrefixedOutputTarget(this.storage.getOutputTarget());
    }

    public String getName() {
        return this.storage.getName();
    }

    public String getFullPath() {
        return this.storage.getFullPath();
    }

    public void clear() {
        HashSet<String> entriesToDelete = new HashSet<String>();
        Iterator<String> it = this.storage.getInputSource().getEntries();
        block0: while (it.hasNext()) {
            String entry = it.next();
            while (entry.startsWith(this.prefix)) {
                entriesToDelete.add(entry);
                int slashIndex = entry.lastIndexOf(47);
                if (slashIndex <= 0) continue block0;
                entry = entry.substring(0, slashIndex);
            }
        }
        ArrayList entryList = new ArrayList(entriesToDelete);
        Collections.sort(entryList, Collections.reverseOrder());
        for (String entry : entryList) {
            this.storage.deleteEntry(entry);
        }
        this.storage.deleteEntry(this.prefix);
    }

    public void deleteEntry(String entryName) {
        this.storage.deleteEntry(String.valueOf(this.prefix) + entryName);
    }

    public void renameEntry(String entryName, String newName) {
        this.storage.renameEntry(String.valueOf(this.prefix) + entryName, String.valueOf(this.prefix) + newName);
    }

    public int hashCode() {
        return this.storage.hashCode() ^ this.prefix.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof PrefixedStorage)) {
            return false;
        }
        PrefixedStorage that = (PrefixedStorage)obj;
        return this.storage.equals(that.storage) && this.prefix.equals(that.prefix);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PrefixedInputSource
    implements IInputSource,
    Closeable {
        private IInputSource source;

        public PrefixedInputSource(IInputSource source) {
            this.source = source;
        }

        @Override
        public boolean hasEntry(String entryName) {
            return this.source.hasEntry(String.valueOf(PrefixedStorage.this.prefix) + entryName);
        }

        @Override
        public Iterator<String> getEntries() {
            return new Iterator<String>(){
                Iterator<String> it;
                String next;
                {
                    this.it = PrefixedInputSource.this.source.getEntries();
                    this.next = this.findNext();
                }

                private String findNext() {
                    while (this.it.hasNext()) {
                        String n = this.it.next();
                        if (n == null || !n.startsWith(PrefixedStorage.this.prefix)) continue;
                        return n.substring(PrefixedStorage.this.prefix.length());
                    }
                    return null;
                }

                @Override
                public void remove() {
                }

                @Override
                public String next() {
                    String n = this.next;
                    this.next = this.findNext();
                    return n;
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }
            };
        }

        @Override
        public boolean isEntryAvailable(String entryName) {
            return this.source.isEntryAvailable(String.valueOf(PrefixedStorage.this.prefix) + entryName);
        }

        @Override
        @Deprecated
        public InputStream getEntryStream(String entryName) {
            return this.source.getEntryStream(String.valueOf(PrefixedStorage.this.prefix) + entryName);
        }

        @Override
        public InputStream openEntryStream(String entryName) throws IOException {
            return this.source.openEntryStream(String.valueOf(PrefixedStorage.this.prefix) + entryName);
        }

        @Override
        public long getEntrySize(String entryName) {
            return this.source.getEntrySize(String.valueOf(PrefixedStorage.this.prefix) + entryName);
        }

        @Override
        public long getEntryTime(String entryName) {
            return this.source.getEntryTime(String.valueOf(PrefixedStorage.this.prefix) + entryName);
        }

        @Override
        public void close() throws IOException {
            if (this.source instanceof Closeable) {
                ((Closeable)((Object)this.source)).close();
            }
        }
    }

    private class PrefixedOutputTarget
    implements IOutputTarget,
    Closeable {
        private IOutputTarget target;

        public PrefixedOutputTarget(IOutputTarget target) {
            this.target = target;
        }

        public boolean isEntryAvaialble(String entryName) {
            return this.target.isEntryAvaialble(String.valueOf(PrefixedStorage.this.prefix) + entryName);
        }

        @Deprecated
        public OutputStream getEntryStream(String entryName) {
            return this.target.getEntryStream(String.valueOf(PrefixedStorage.this.prefix) + entryName);
        }

        public OutputStream openEntryStream(String entryName) throws IOException {
            return this.target.openEntryStream(String.valueOf(PrefixedStorage.this.prefix) + entryName);
        }

        public void setEntryTime(String entryName, long time) {
            this.target.setEntryTime(String.valueOf(PrefixedStorage.this.prefix) + entryName, time);
        }

        public void close() throws IOException {
            if (this.target instanceof Closeable) {
                ((Closeable)((Object)this.target)).close();
            }
        }
    }
}

