/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import java.util.Arrays;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.actions.ActionFactory;
import org.xmind.core.Core;
import org.xmind.core.ICloneData;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapUI;

public class SaveSheetAsAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private IGraphicalEditorPage page;

    public SaveSheetAsAction() {
        this.setId("org.xmind.ui.saveSheetAs");
        this.setText(MindMapMessages.SaveSheetAs_text);
        this.setToolTipText(MindMapMessages.SaveSheetAs_toolTip);
    }

    public void setActivePage(IGraphicalEditorPage page) {
        this.page = page;
        this.setEnabled(page != null && page.getAdapter(IMindMap.class) != null);
    }

    public void run() {
        if (this.page == null) {
            return;
        }
        IMindMap mindmap = (IMindMap)this.page.getAdapter(IMindMap.class);
        if (mindmap == null) {
            return;
        }
        ISheet sheet = mindmap.getSheet();
        final IWorkbook newWorkbook = Core.getWorkbookBuilder().createWorkbook(MME.createTempStorage());
        try {
            newWorkbook.saveTemp();
        }
        catch (Exception exception) {}
        ICloneData clone = newWorkbook.clone(Arrays.asList(sheet));
        ISheet newSheet = (ISheet)clone.get((Object)sheet);
        this.initSheet(newSheet);
        ITopic newCentralTopic = (ITopic)clone.get((Object)mindmap.getCentralTopic());
        if (newCentralTopic == null) {
            return;
        }
        newSheet.replaceRootTopic(newCentralTopic);
        newWorkbook.addSheet(newSheet);
        newWorkbook.removeSheet(newWorkbook.getPrimarySheet());
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                final IEditorPart newEditor = SaveSheetAsAction.this.page.getParentEditor().getSite().getPage().openEditor(MindMapUI.getEditorInputFactory().createEditorInputForPreLoadedWorkbook(newWorkbook, null), "org.xmind.ui.MindMapEditor", true);
                if (newWorkbook instanceof ICoreEventSource2) {
                    ((ICoreEventSource2)newWorkbook).registerOnceCoreEventListener("workbookPreSaveOnce", ICoreEventListener.NULL);
                }
                if (newEditor != null && newEditor instanceof ISaveablePart) {
                    Display.getCurrent().timerExec(500, new Runnable(){

                        @Override
                        public void run() {
                            newEditor.doSaveAs();
                        }
                    });
                }
            }
        });
    }

    private void initSheet(ISheet sheet) {
        this.initTopic(sheet.getRootTopic());
    }

    private void initTopic(ITopic topic) {
        for (ITopic child : topic.getAllChildren()) {
            this.initTopic(child);
        }
    }

    public void dispose() {
        this.page = null;
    }
}

