/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.ui.decorations.AbstractTopicDecoration;
import org.xmind.ui.internal.svgsupport.SvgPathParser;
import org.xmind.ui.mindmap.IBranchPart;

public class StrokeCircleTopicDecoration
extends AbstractTopicDecoration {
    private static final float scaleLeft = 0.13f;
    private static final float scaleRight = 0.13f;
    private static final float scaleTop = 0.13f;
    private static final float scaleBottom = 0.27f;
    private IBranchPart branch;
    private String innerSvgPath;
    private String outerSvgPath;

    public StrokeCircleTopicDecoration() {
    }

    public StrokeCircleTopicDecoration(String id) {
        super(id);
    }

    public StrokeCircleTopicDecoration(String id, IBranchPart branch, String innerSvgPath, String outerSvgPath) {
        super(id);
        this.branch = branch;
        this.innerSvgPath = innerSvgPath;
        this.outerSvgPath = outerSvgPath;
    }

    protected void sketch(IFigure figure, org.xmind.gef.draw2d.graphics.Path shape, Rectangle box, int purpose) {
        org.xmind.gef.draw2d.graphics.Path innerPath = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        SvgPathParser parser = SvgPathParser.getInstance();
        float halfLineWidth = (float)this.getLineWidth() * 0.5f;
        if (purpose == 3) {
            parser.parseSvgPath(innerPath, (float)box.getCenter().x - halfLineWidth, (float)box.getCenter().y + halfLineWidth, box.width + this.getLineWidth(), box.height + this.getLineWidth(), this.innerSvgPath);
        } else {
            parser.parseSvgPath(innerPath, box.getCenter().x + 1, box.getCenter().y + 1, box.width, box.height, this.innerSvgPath);
        }
        innerPath.close();
        shape.addPath((Path)innerPath);
    }

    public PrecisionPoint getAnchorLocation(IFigure figure, double refX, double refY, double expansion) {
        if (this.branch != null && this.branch.getTopic().isRoot()) {
            float scaleWidth = 0.74f;
            float scaleHeight = 0.6f;
            Rectangle bounds = figure.getBounds();
            Point tf = bounds.getTopLeft().getTranslated((double)((float)bounds.width * 0.13f), (double)((float)bounds.height * 0.13f));
            Rectangle area = new Rectangle(tf.x, tf.y, (int)((float)bounds.width * scaleWidth), (int)((float)bounds.height * scaleHeight));
            return Geometry.getChopBoxLocation((double)refX, (double)refY, (Rectangle)area, (double)expansion);
        }
        return super.getAnchorLocation(figure, refX, refY, expansion);
    }

    @Override
    public Insets getPreferredInsets(IFigure figure, int width, int height) {
        float scaleWidth = 0.74f;
        float scaleHeight = 0.6f;
        return new Insets((int)((float)(height + this.getTopMargin() + this.getLineWidth()) / scaleHeight * 0.13f), (int)((float)(width + this.getLeftMargin() + this.getLineWidth()) / scaleWidth * 0.13f), (int)((float)(height + this.getBottomMargin() + this.getLineWidth()) / scaleHeight * 0.27f), (int)((float)(width + this.getRightMargin() + this.getLineWidth()) / scaleWidth * 0.13f));
    }

    protected boolean containsPoint(IFigure figure, int x, int y, boolean outline) {
        this.checkValidation(figure);
        boolean ret = figure.getBounds().contains(x, y);
        return ret;
    }

    protected void paintOutline(IFigure figure, Graphics graphics) {
        Rectangle box = this.getOutlineBox(figure);
        if (this.getLineWidth() != 0 && this.outerSvgPath != null) {
            graphics.setBackgroundColor(graphics.getForegroundColor());
            org.xmind.gef.draw2d.graphics.Path outerPath = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
            SvgPathParser parser = SvgPathParser.getInstance();
            parser.parseSvgPath(outerPath, box.getCenter().x, box.getCenter().y + 1, box.width, box.height, this.outerSvgPath);
            graphics.drawPath((Path)outerPath);
            graphics.fillPath((Path)outerPath);
            outerPath.close();
        } else {
            super.paintOutline(figure, graphics);
        }
    }
}

