/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.ui.dialogs.HyperlinkPage;
import org.xmind.ui.internal.dialogs.DialogMessages;

public class TopicHyperlinkPage
extends HyperlinkPage {
    public Composite composite;
    public IWorkbook workbook;
    public boolean isModifyValue = false;
    public String str;
    private TreeViewer topicViewer;

    @Override
    public void init(IEditorPart editor, IStructuredSelection selection) {
        this.workbook = (IWorkbook)editor.getAdapter(IWorkbook.class);
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.createLabel(this.composite);
        this.createTopicViewer(this.composite);
    }

    private void createLabel(Composite parent) {
        Label label = new Label(parent, 64);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label.setText(DialogMessages.TopicHyperlinkPage_label);
    }

    private void createTopicViewer(Composite parent) {
        PatternFilter filter = new PatternFilter();
        FilteredTree tree = new FilteredTree(parent, 2820, filter, true);
        this.topicViewer = tree.getViewer();
        this.topicViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.topicViewer.setAutoExpandLevel(2);
        this.topicViewer.setContentProvider((IContentProvider)new TopicPageContentProvider());
        this.topicViewer.setLabelProvider((IBaseLabelProvider)new TopicPageLabelProvider());
        if (this.workbook != null) {
            this.topicViewer.setInput((Object)this.workbook);
        }
        this.topicViewer.addSelectionChangedListener((ISelectionChangedListener)new TopicSelectionListener());
    }

    @Override
    public void setValue(String value) {
        super.setValue(value);
        if (!this.isModifyValue && this.topicViewer != null && this.topicViewer.getControl() != null && !this.topicViewer.getControl().isDisposed()) {
            Object element = this.getElement(value);
            if (element != null) {
                this.topicViewer.setSelection((ISelection)new StructuredSelection(element), true);
            } else {
                this.topicViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        }
    }

    private Object getElement(String value) {
        if (value == null) {
            return null;
        }
        if (this.workbook == null) {
            return null;
        }
        return HyperlinkUtils.findElement((String)value, (IWorkbook)this.workbook);
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.composite;
    }

    public void setFocus() {
        Control control;
        if (this.topicViewer != null && (control = this.topicViewer.getControl()) != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    private class TopicPageContentProvider
    implements ITreeContentProvider {
        private TopicPageContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IWorkbook) {
                List sheets = ((IWorkbook)inputElement).getSheets();
                ArrayList<ITopic> rootTopics = new ArrayList<ITopic>(sheets.size());
                for (ISheet sheet : sheets) {
                    rootTopics.add(sheet.getRootTopic());
                }
                return rootTopics.toArray();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ITopic) {
                return !((ITopic)element).getAllChildren().isEmpty();
            }
            return false;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ITopic) {
                return ((ITopic)parentElement).getAllChildren().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof ITopic) {
                ITopic topic = (ITopic)element;
                if (topic.isRoot()) {
                    return topic.getOwnedWorkbook();
                }
                return topic.getParent();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TopicPageLabelProvider
    extends LabelProvider {
        private TopicPageLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ITopic) {
                ITopic topic = (ITopic)element;
                if (topic.isRoot()) {
                    return String.valueOf(topic.getTitleText()) + " (" + topic.getOwnedSheet().getTitleText() + ")";
                }
                String titleText = topic.getTitleText();
                return titleText.replaceAll("\\r\\n|\\n|\\r", " ");
            }
            return super.getText(element);
        }
    }

    private class TopicSelectionListener
    implements ISelectionChangedListener {
        private TopicSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection ss;
            Object element;
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof ITopic) {
                TopicHyperlinkPage.this.isModifyValue = true;
                TopicHyperlinkPage.this.setValue(HyperlinkUtils.toInternalURL((Object)((ITopic)element)));
                TopicHyperlinkPage.this.isModifyValue = false;
                TopicHyperlinkPage.this.setCanFinish(true);
            }
        }
    }
}

