/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xmind.core.ISettingEntry;
import org.xmind.core.ISheet;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.commands.ModifySheetTabColorCommand;

public class ColorfulSheetHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.changeTabColor(event);
        return null;
    }

    private void changeTabColor(ExecutionEvent event) {
        IGraphicalEditorPage page = this.getActivePage(event);
        if (page == null) {
            return;
        }
        ISheet sheet = (ISheet)page.getAdapter(ISheet.class);
        String rgb = event.getParameter("org.xmind.ui.command.colorfulSheet.rgbParameter");
        String oldRgb = this.getRgb(sheet);
        if ((oldRgb == null || oldRgb.equals("")) && (rgb == null || rgb.equals("")) || oldRgb != null && oldRgb.equals(rgb)) {
            return;
        }
        ModifySheetTabColorCommand command = new ModifySheetTabColorCommand(sheet, rgb);
        ICommandStack cs = page.getEditDomain().getCommandStack();
        if (cs != null) {
            cs.execute((Command)command);
        }
    }

    private IGraphicalEditorPage getActivePage(ExecutionEvent event) {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor instanceof IGraphicalEditor) {
            return ((IGraphicalEditor)editor).getActivePageInstance();
        }
        return null;
    }

    private String getRgb(ISheet sheet) {
        ISettingEntry entry = this.findEntry(sheet);
        return entry == null ? null : entry.getAttribute("rgb");
    }

    private ISettingEntry findEntry(ISheet sheet) {
        List entries = sheet.getSettings().getEntries("tab-color");
        return entries.size() == 0 ? null : (ISettingEntry)entries.get(0);
    }
}

