/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.color.ColorPicker;
import org.xmind.ui.color.ColorSelection;
import org.xmind.ui.color.IColorSelection;
import org.xmind.ui.color.PaletteContents;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.properties.StyledPropertySectionPart;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.richtext.AlignmentGroup;
import org.xmind.ui.richtext.TextCaseGroup;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.style.TextStyleData;
import org.xmind.ui.viewers.MComboViewer;

public class FontPropertySectionPart
extends StyledPropertySectionPart {
    private static Set<Integer> FONT_SIZE_LIST = new TreeSet<Integer>();
    private IAction boldAction;
    private IAction italicAction;
    private IAction strikeoutAction;
    private MComboViewer fontViewer;
    private MComboViewer sizeViewer;
    private TextStyleData currentTextStyle;
    private ColorPicker textColorPicker;
    private AlignmentGroup alignGroup;
    private IAction alignLeftAction;
    private IAction alignCenterAction;
    private IAction alignRightAction;
    private TextCaseGroup caseGroup;
    private IAction manualAction;
    private IAction uppercaseAction;
    private IAction lowercaseAction;
    private IAction capitalizeAction;

    @Override
    protected void createContent(Composite parent) {
        Composite line1 = new Composite(parent, 0);
        line1.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout1 = new GridLayout(1, false);
        layout1.marginWidth = 0;
        layout1.marginHeight = 0;
        layout1.horizontalSpacing = 3;
        layout1.verticalSpacing = 3;
        line1.setLayout((Layout)layout1);
        this.createLineContent1(line1);
        Composite line2 = new Composite(parent, 0);
        line2.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        layout2.horizontalSpacing = 3;
        layout2.verticalSpacing = 3;
        line2.setLayout((Layout)layout2);
        this.createLineContent2(line2);
    }

    private void createLineContent1(Composite parent) {
        this.fontViewer = new MComboViewer(parent, 1024);
        this.fontViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.fontViewer.getControl().setToolTipText(PropertyMessages.FontFamily_toolTip);
        this.fontViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fontViewer.setLabelProvider((IBaseLabelProvider)new FontLabelProvider());
        this.fontViewer.setInput((Object)FontUtils.getAvailableFontNames());
        TextStyleData ts = this.calcCurrentTextStyle();
        if (ts != null && ts.name != null) {
            this.fontViewer.setSelection((ISelection)new StructuredSelection((Object)ts.name));
        }
        this.fontViewer.addSelectionChangedListener((ISelectionChangedListener)new FontSelectionChangedListener());
    }

    private void createLineContent2(Composite parent) {
        this.sizeViewer = new MComboViewer(parent, 1024);
        this.sizeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.sizeViewer.getControl().setToolTipText(PropertyMessages.FontSize_toolTip);
        this.sizeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.sizeViewer.setLabelProvider((IBaseLabelProvider)new SizeLabelProvider());
        this.sizeViewer.setPermitsUnprovidedElement(true);
        if (FONT_SIZE_LIST.isEmpty()) {
            FONT_SIZE_LIST.addAll(Arrays.asList(8, 9, 10, 11, 12, 13, 14, 16, 18, 20, 22, 24, 36, 48, 56));
        }
        this.sizeViewer.setInput(FONT_SIZE_LIST);
        this.sizeViewer.addSelectionChangedListener((ISelectionChangedListener)new SizeSelectionChangedListener());
        ToolBarManager styleBar = new ToolBarManager(0x800000);
        this.boldAction = new BoldAction();
        styleBar.add(this.boldAction);
        this.italicAction = new ItalicAction();
        styleBar.add(this.italicAction);
        this.strikeoutAction = new StrikeoutAction();
        styleBar.add(this.strikeoutAction);
        this.textColorPicker = new ColorPicker(5, PaletteContents.getDefault());
        this.textColorPicker.getAction().setToolTipText(PropertyMessages.TextColor_toolTip);
        this.textColorPicker.addOpenListener((IOpenListener)new ColorOpenListener());
        styleBar.add((IContributionItem)this.textColorPicker);
        this.alignGroup = new AlignmentGroup();
        this.alignLeftAction = new AlignLeftAction();
        this.alignGroup.add(this.alignLeftAction);
        this.alignCenterAction = new AlignCenterAction();
        this.alignGroup.add(this.alignCenterAction);
        this.alignRightAction = new AlignRightAction();
        this.alignGroup.add(this.alignRightAction);
        styleBar.add((IContributionItem)this.alignGroup);
        this.caseGroup = new TextCaseGroup();
        this.manualAction = new TextManualAction();
        this.caseGroup.add(this.manualAction);
        this.uppercaseAction = new TextUppercaseAction();
        this.caseGroup.add(this.uppercaseAction);
        this.lowercaseAction = new TextLowercaseAction();
        this.caseGroup.add(this.lowercaseAction);
        this.capitalizeAction = new TextCapitalizeAction();
        this.caseGroup.add(this.capitalizeAction);
        styleBar.add((IContributionItem)this.caseGroup);
        ToolBar barControl = styleBar.createControl(parent);
        barControl.setLayoutData((Object)new GridData(3, 2, false, false));
    }

    @Override
    protected void doRefresh() {
        TextStyleData ts;
        this.currentTextStyle = ts = this.calcCurrentTextStyle();
        if (this.fontViewer != null && !this.fontViewer.getControl().isDisposed() && this.fontViewer.getControl().isEnabled()) {
            this.fontViewer.setSelection((ISelection)(ts == null || ts.name == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)ts.name)));
        }
        if (this.sizeViewer != null && !this.sizeViewer.getControl().isDisposed()) {
            this.sizeViewer.setSelection((ISelection)(ts == null || ts.height < 0 ? StructuredSelection.EMPTY : new StructuredSelection((Object)ts.height)));
        }
        if (this.boldAction != null) {
            this.boldAction.setChecked(ts != null && ts.bold);
        }
        if (this.italicAction != null) {
            this.italicAction.setChecked(ts != null && ts.italic);
        }
        if (this.strikeoutAction != null) {
            this.strikeoutAction.setChecked(ts != null && ts.strikeout);
        }
        if (this.textColorPicker != null) {
            this.updateColorPicker(this.textColorPicker);
        }
        switch (ts == null ? 1 : ts.align) {
            case 1: {
                if (this.alignLeftAction == null) break;
                this.alignLeftAction.setChecked(ts != null);
                break;
            }
            case 2: {
                if (this.alignCenterAction == null) break;
                this.alignCenterAction.setChecked(ts != null);
                break;
            }
            case 4: {
                if (this.alignRightAction == null) break;
                this.alignRightAction.setChecked(ts != null);
            }
        }
        switch (ts == null ? 1 : ts.textCase) {
            case 1: {
                if (this.manualAction == null) break;
                this.manualAction.setChecked(ts != null);
                break;
            }
            case 2: {
                if (this.uppercaseAction == null) break;
                this.uppercaseAction.setChecked(ts != null);
                break;
            }
            case 4: {
                if (this.lowercaseAction == null) break;
                this.lowercaseAction.setChecked(ts != null);
                break;
            }
            case 8: {
                if (this.capitalizeAction == null) break;
                this.capitalizeAction.setChecked(ts != null);
            }
        }
    }

    private void updateColorPicker(ColorPicker picker) {
        if (this.currentTextStyle == null || this.currentTextStyle.color == null) {
            picker.setSelection((ISelection)ColorSelection.EMPTY);
            picker.setAutoColor(null);
        } else {
            int type;
            IGraphicalPart part = this.getGraphicalPart(this.getSelectedElements()[0]);
            if (part == null) {
                return;
            }
            IStyleSelector ss = this.getStyleSelector(part);
            if (ss == null) {
                return;
            }
            String autoValue = ss.getAutoValue(part, "fo:color");
            RGB autoColor = StyleUtils.convertRGB("fo:color", autoValue);
            picker.setAutoColor(autoColor);
            String userValue = ss.getUserValue(part, "fo:color");
            if (userValue == null) {
                type = 1;
                userValue = autoValue;
            } else {
                type = 3;
            }
            if (type != 1 && "none".equals(userValue)) {
                type = 2;
            }
            RGB color = StyleUtils.convertRGB("fo:color", userValue);
            picker.setSelection((ISelection)new ColorSelection(type, color));
        }
    }

    protected TextStyleData calcCurrentTextStyle() {
        TextStyleData textStyle = null;
        IGraphicalViewer viewer = this.getActiveViewer();
        if (viewer != null) {
            Object[] objectArray = this.getSelectedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                IGraphicalPart part = this.getGraphicalPart(o, (IViewer)viewer);
                if (part != null) {
                    IStyleSelector ss = this.getStyleSelector(part);
                    TextStyleData ts = this.calcTextStyle(part, ss);
                    if (ts == null) {
                        return null;
                    }
                    textStyle = this.mergeStyle(textStyle, ts);
                    if (!(textStyle.name != null || textStyle.height >= 0 || textStyle.color != null || textStyle.italic || textStyle.bold || textStyle.underline || textStyle.strikeout)) {
                        textStyle = null;
                        break;
                    }
                }
                ++n2;
            }
        }
        return textStyle;
    }

    private TextStyleData mergeStyle(TextStyleData source, TextStyleData target) {
        if (source == null) {
            return new TextStyleData(target);
        }
        if (source.name != null && !source.name.equals(target.name)) {
            source.name = null;
        }
        if (source.height > 0 && source.height != target.height) {
            source.height = -1;
        }
        if (source.italic && !target.italic) {
            source.italic = false;
        }
        if (source.bold && !target.bold) {
            source.bold = false;
        }
        if (source.color != null && !source.color.equals((Object)target.color)) {
            source.color = null;
        }
        if (source.strikeout && !target.strikeout) {
            source.strikeout = false;
        }
        if (source.underline && !target.underline) {
            source.underline = false;
        }
        if (source.align != target.align) {
            source.align = 16384;
        }
        if (source.textCase != target.textCase) {
            source.textCase = 1;
        }
        return source;
    }

    private TextStyleData calcTextStyle(IGraphicalPart part, IStyleSelector ss) {
        return StyleUtils.getTextStyleData(part, ss, null);
    }

    public void setFocus() {
        if (this.fontViewer != null && !this.fontViewer.getControl().isDisposed()) {
            this.fontViewer.getControl().setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.fontViewer = null;
        this.sizeViewer = null;
        this.currentTextStyle = null;
        this.boldAction = null;
        this.italicAction = null;
        this.strikeoutAction = null;
        this.currentTextStyle = null;
        this.textColorPicker = null;
        this.alignLeftAction = null;
        this.alignCenterAction = null;
        this.alignRightAction = null;
        this.manualAction = null;
        this.uppercaseAction = null;
        this.lowercaseAction = null;
        this.capitalizeAction = null;
    }

    private void changeFontName(String name) {
        this.sendRequest(this.addStyle(this.createStyleRequest(CommandMessages.Command_ModifyFont), "fo:font-family", name));
    }

    private void changeFontSize(int fontHeight) {
        this.sendRequest(this.addStyle(this.createStyleRequest(CommandMessages.Command_ModifyFont), "fo:font-size", StyleUtils.addUnitPoint(fontHeight)));
    }

    private void changeBold(boolean bold) {
        this.sendRequest(this.addStyle(this.createStyleRequest(CommandMessages.Command_ModifyFont), "fo:font-weight", bold ? "bold" : "normal"));
    }

    private void changeItalic(boolean italic) {
        this.sendRequest(this.addStyle(this.createStyleRequest(CommandMessages.Command_ModifyFont), "fo:font-style", italic ? "italic" : "normal"));
    }

    private void changeStrikeout(boolean strikeout) {
        String decoration = null;
        if (this.currentTextStyle != null && this.currentTextStyle.underline) {
            decoration = "underline";
        }
        if (decoration == null) {
            decoration = strikeout ? "line-through" : "normal";
        } else if (strikeout) {
            decoration = String.valueOf(decoration) + " " + "line-through";
        }
        this.sendRequest(this.addStyle(this.createStyleRequest(CommandMessages.Command_ModifyFont), "fo:text-decoration", decoration));
    }

    private void changeAlignLeft() {
        Request leftReq = this.createStyleRequest(CommandMessages.Command_TextAlignLeft);
        Request request = this.addStyle(leftReq, "fo:text-align", "left");
        this.sendRequest(request);
    }

    private void changeAlignCenter() {
        Request centerReq = this.createStyleRequest(CommandMessages.Command_TextAlignCenter);
        Request request = this.addStyle(centerReq, "fo:text-align", "center");
        this.sendRequest(request);
    }

    private void changeAlignRight() {
        Request rightReq = this.createStyleRequest(CommandMessages.Command_TextAlignRight);
        Request request = this.addStyle(rightReq, "fo:text-align", "right");
        this.sendRequest(request);
    }

    private void changeTextColor(IColorSelection selection) {
        this.changeColor(selection, "fo:color", CommandMessages.Command_ModifyTextColor);
    }

    private void changeTextManual() {
        Request manualReq = this.createStyleRequest(CommandMessages.Command_TextManual);
        Request request = this.addStyle(manualReq, "fo:text-transform", "manual");
        this.sendRequest(request);
    }

    private void changeTextUppercase() {
        Request manualReq = this.createStyleRequest(CommandMessages.Command_TextUppercase);
        Request request = this.addStyle(manualReq, "fo:text-transform", "uppercase");
        this.sendRequest(request);
    }

    private void changeTextLowercase() {
        Request manualReq = this.createStyleRequest(CommandMessages.Command_TextLowercase);
        Request request = this.addStyle(manualReq, "fo:text-transform", "lowercase");
        this.sendRequest(request);
    }

    private void changeTextCapitalize() {
        Request manualReq = this.createStyleRequest(CommandMessages.Command_TextCapitalize);
        Request request = this.addStyle(manualReq, "fo:text-transform", "capitalize");
        this.sendRequest(request);
    }

    private class AlignCenterAction
    extends Action {
        public AlignCenterAction() {
            super(PropertyMessages.TextAlignCenter_text, MindMapUI.getImages().get("align_center.png", true));
            this.setToolTipText(PropertyMessages.TextAlignCenter_toolTip);
            this.setChecked(false);
        }

        public void run() {
            FontPropertySectionPart.this.changeAlignCenter();
        }
    }

    private class AlignLeftAction
    extends Action {
        public AlignLeftAction() {
            super(PropertyMessages.TextAlignLeft_text, MindMapUI.getImages().get("align_left.png", true));
            this.setToolTipText(PropertyMessages.TextAlignLeft_toolTip);
            this.setChecked(false);
        }

        public void run() {
            FontPropertySectionPart.this.changeAlignLeft();
        }
    }

    private class AlignRightAction
    extends Action {
        public AlignRightAction() {
            super(PropertyMessages.TextAlignRight_text, MindMapUI.getImages().get("align_right.png", true));
            this.setToolTipText(PropertyMessages.TextAlignRight_toolTip);
            this.setChecked(false);
        }

        public void run() {
            FontPropertySectionPart.this.changeAlignRight();
        }
    }

    private class BoldAction
    extends Action {
        public BoldAction() {
            super(null, MindMapUI.getImages().get("text_bold.png", true));
            this.setToolTipText(PropertyMessages.Bold_toolTip);
            this.setChecked(false);
        }

        public void run() {
            super.run();
            FontPropertySectionPart.this.changeBold(this.isChecked());
        }
    }

    private class ColorOpenListener
    implements IOpenListener {
        private ColorOpenListener() {
        }

        public void open(OpenEvent event) {
            FontPropertySectionPart.this.changeTextColor((IColorSelection)event.getSelection());
        }
    }

    private class FontLabelProvider
    extends LabelProvider {
        private FontLabelProvider() {
        }
    }

    private class FontSelectionChangedListener
    implements ISelectionChangedListener {
        private FontSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (FontPropertySectionPart.this.isRefreshing()) {
                return;
            }
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (o instanceof String) {
                FontPropertySectionPart.this.changeFontName((String)o);
                MindMapUIPlugin.getDefault().getUsageDataCollector().increase("FontChangeAllCount");
            }
        }
    }

    private class ItalicAction
    extends Action {
        public ItalicAction() {
            super(null, MindMapUI.getImages().get("text_italic.png", true));
            this.setToolTipText(PropertyMessages.Italic_toolTip);
            this.setChecked(false);
        }

        public void run() {
            super.run();
            FontPropertySectionPart.this.changeItalic(this.isChecked());
        }
    }

    private class SizeLabelProvider
    extends LabelProvider {
        private SizeLabelProvider() {
        }
    }

    private class SizeSelectionChangedListener
    implements ISelectionChangedListener {
        private SizeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (FontPropertySectionPart.this.isRefreshing()) {
                return;
            }
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (o instanceof String) {
                try {
                    int i = Integer.parseInt((String)o);
                    FONT_SIZE_LIST.add(i);
                    FontPropertySectionPart.this.changeFontSize(i);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (o instanceof Integer) {
                FontPropertySectionPart.this.changeFontSize((Integer)o);
            }
        }
    }

    private class StrikeoutAction
    extends Action {
        public StrikeoutAction() {
            super(null, MindMapUI.getImages().get("text_strikeout.png", true));
            this.setToolTipText(PropertyMessages.Strikeout_toolTip);
            this.setChecked(false);
        }

        public void run() {
            super.run();
            FontPropertySectionPart.this.changeStrikeout(this.isChecked());
        }
    }

    private class TextCapitalizeAction
    extends Action {
        public TextCapitalizeAction() {
            super(PropertyMessages.TextCapitalize_text, MindMapUI.getImages().get("text_capitalize.png", true));
            this.setToolTipText(PropertyMessages.TextCapitalize_toolTip);
            this.setChecked(false);
        }

        public void run() {
            FontPropertySectionPart.this.changeTextCapitalize();
        }
    }

    private class TextLowercaseAction
    extends Action {
        public TextLowercaseAction() {
            super(PropertyMessages.TextLowercase_text, MindMapUI.getImages().get("text_lowercase.png", true));
            this.setToolTipText(PropertyMessages.TextLowercase_toolTip);
            this.setChecked(false);
        }

        public void run() {
            FontPropertySectionPart.this.changeTextLowercase();
        }
    }

    private class TextManualAction
    extends Action {
        public TextManualAction() {
            super(PropertyMessages.TextManual_text, MindMapUI.getImages().get("text_manual.png", true));
            this.setToolTipText(PropertyMessages.TextManual_toolTip);
            this.setChecked(false);
        }

        public void run() {
            FontPropertySectionPart.this.changeTextManual();
        }
    }

    private class TextUppercaseAction
    extends Action {
        public TextUppercaseAction() {
            super(PropertyMessages.TextUppercase_text, MindMapUI.getImages().get("text_uppercase.png", true));
            this.setToolTipText(PropertyMessages.TextUppercase_toolTip);
            this.setChecked(false);
        }

        public void run() {
            FontPropertySectionPart.this.changeTextUppercase();
        }
    }
}

