/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.xmind.core.ILegend;
import org.xmind.core.ISheet;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.Request;
import org.xmind.ui.color.ColorPicker;
import org.xmind.ui.color.IColorSelection;
import org.xmind.ui.color.PaletteContents;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.properties.StyledPropertySectionPart;

public class LegendPropertySectionPart
extends StyledPropertySectionPart {
    private Button visibilityCheck;
    private Control bar;
    private ColorPicker backgroundColorPicker;

    @Override
    protected void createContent(Composite parent) {
        this.visibilityCheck = new Button(parent, 32);
        this.visibilityCheck.setLayoutData((Object)new GridData(4, 2, true, false));
        this.visibilityCheck.setText(PropertyMessages.ShowLegend_text);
        this.visibilityCheck.setToolTipText(PropertyMessages.ShowLegend_toolTip);
        this.visibilityCheck.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LegendPropertySectionPart.this.changeLegendVisibility(LegendPropertySectionPart.this.visibilityCheck.getSelection());
            }
        });
        this.createBackgroundPart(parent);
    }

    private void createBackgroundPart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(22, false);
        layout.horizontalSpacing = 7;
        composite.setLayout((Layout)layout);
        Label caption = new Label(composite, 0);
        caption.setText(PropertyMessages.BackgroundColor_label);
        caption.setLayoutData((Object)new GridData(4, 2, false, false));
        this.backgroundColorPicker = new ColorPicker(5, PaletteContents.getDefault());
        this.backgroundColorPicker.getAction().setToolTipText(PropertyMessages.LegendBackground_toolTip);
        this.backgroundColorPicker.addOpenListener((IOpenListener)new BackgroundColorOpenListener());
        ToolBarManager colorBar = new ToolBarManager(0x800000);
        colorBar.add((IContributionItem)this.backgroundColorPicker);
        this.bar = colorBar.createControl(composite);
        this.bar.setLayoutData((Object)new GridData(1, 2, false, false));
    }

    @Override
    protected void registerEventListener(Object source, ICoreEventRegister register) {
        if (source instanceof ISheet) {
            ILegend legend = ((ISheet)source).getLegend();
            register.setNextSourceFrom((Object)legend);
            register.register("visibility");
        }
    }

    @Override
    protected void doRefresh() {
        if (this.visibilityCheck != null && !this.visibilityCheck.isDisposed()) {
            this.visibilityCheck.setSelection(this.isLegendVisible());
        }
        this.updateColorPicker(this.backgroundColorPicker, "legendFillColor", null);
    }

    private boolean isLegendVisible() {
        Object[] objectArray = this.getSelectedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILegend legend;
            Object o = objectArray[n2];
            if (o instanceof ISheet && !(legend = ((ISheet)o).getLegend()).isVisible()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void setFocus() {
        if (this.visibilityCheck != null && !this.visibilityCheck.isDisposed()) {
            this.visibilityCheck.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.visibilityCheck = null;
        this.bar = null;
        this.backgroundColorPicker = null;
    }

    protected void changeLegendVisibility(boolean visible) {
        Request request = new Request(visible ? "show_legend" : "hide_legend");
        this.sendRequest(this.fillTargets(request));
    }

    private void changeBackgroundColor(IColorSelection selection) {
        this.changeColor(selection, "legendFillColor", CommandMessages.Command_ModifyLegendBackgroundColor);
    }

    private class BackgroundColorOpenListener
    implements IOpenListener {
        private BackgroundColorOpenListener() {
        }

        public void open(OpenEvent event) {
            MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ChangeLegendBackgroudCount");
            LegendPropertySectionPart.this.changeBackgroundColor((IColorSelection)event.getSelection());
        }
    }
}

