/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.resourcemanager;

import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.xmind.ui.internal.e4models.IModelPartContext;
import org.xmind.ui.internal.e4models.ModelPageContainer;
import org.xmind.ui.internal.resourcemanager.IResourceManagerDialogPage;
import org.xmind.ui.internal.resourcemanager.ResourceManagerViewer;

public abstract class ResourceManagerDialogPage
extends ModelPageContainer
implements IResourceManagerDialogPage {
    private static final int BUTTON_MIN_WIDTH = Util.isMac() ? 150 : 120;
    private Image image;
    private ImageDescriptor imageDescriptor;
    private String pageId;
    private String title;
    @Inject
    protected IModelPartContext context;
    private ResourceManagerViewer viewer;

    protected Control createMainPage(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayoutFactory.swtDefaults().spacing(0, 0).margins(0, 0).applyTo(composite);
        Composite viewerComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 0).applyTo(viewerComposite);
        viewerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = this.createViewer();
        this.context.setSelectionProvider((ISelectionProvider)this.viewer);
        this.context.registerContextMenu((Object)viewerComposite, this.getContextMenuId());
        this.viewer.createControl(viewerComposite);
        this.createButtonBar(composite);
        this.registerRunnable(((MPart)this.context.getAdapter(MPart.class)).getContext());
        return composite;
    }

    protected void registerRunnable(IEclipseContext eclipseContext) {
    }

    protected abstract ResourceManagerViewer createViewer();

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 0).applyTo(composite);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.heightHint = 40;
        composite.setLayoutData((Object)gridData);
        Composite buttonBar = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 15;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        buttonBar.setLayout((Layout)layout);
        buttonBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
        buttonBar.setFont(parent.getFont());
        this.createButtonsForButtonBar(buttonBar);
        return buttonBar;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)new Integer(id));
        GridData gridData = new GridData(4, 0, false, false);
        button.setLayoutData((Object)gridData);
        gridData.widthHint = Math.max(gridData.widthHint, BUTTON_MIN_WIDTH);
        return button;
    }

    public void setFocus() {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    @Override
    public void dispose() {
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ISelectionProvider.class.equals(adapter)) {
            return adapter.cast((Object)this.viewer);
        }
        if (Viewer.class.equals(adapter)) {
            return adapter.cast((Object)this.viewer);
        }
        return null;
    }

    @Override
    public String getId() {
        return this.pageId == null ? this.getModelPageId() : this.pageId;
    }

    @Override
    public void setId(String id) {
        this.pageId = id;
    }

    @Override
    public String getTitle() {
        return this.title == null ? this.getModelPageTitle() : this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setImageDescriptor(ImageDescriptor imageDes) {
        this.imageDescriptor = imageDes;
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    @Override
    public Image getImage() {
        if (this.image == null && this.imageDescriptor != null) {
            this.image = this.imageDescriptor.createImage();
        }
        return this.image;
    }

    @Override
    public void refresh() {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.refresh();
        }
    }

    protected abstract String getContextMenuId();
}

