/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.svgsupport;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmind.ui.internal.svgsupport.ColorRecognizer;
import org.xmind.ui.internal.svgsupport.SVGColor;
import org.xmind.ui.internal.svgsupport.SVGDefinition;

class LinearGradient
implements SVGDefinition {
    private static final SVGColor FOREGROUND = new SVGColor(65535);
    private static final SVGColor BACKGROUND = new SVGColor(0);
    private static final float DEFAULT_OPACITY = 1.0f;
    private float x1;
    private float x2;
    private float y1;
    private float y2;
    private List<Stop> stops;

    LinearGradient() {
    }

    protected static LinearGradient parseLinearGradient(Element ele) {
        LinearGradient linear = new LinearGradient();
        linear.x1 = Float.valueOf(ele.getAttribute("x1").split("%")[0]).floatValue() / 100.0f;
        linear.x2 = Float.valueOf(ele.getAttribute("x2").split("%")[0]).floatValue() / 100.0f;
        linear.y1 = Float.valueOf(ele.getAttribute("y1").split("%")[0]).floatValue() / 100.0f;
        linear.y2 = Float.valueOf(ele.getAttribute("y2").split("%")[0]).floatValue() / 100.0f;
        NodeList list = ele.getElementsByTagName("stop");
        ArrayList<Stop> stops = new ArrayList<Stop>();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                stops.add(LinearGradient.parseStop((Element)node));
            }
            ++i;
        }
        linear.setStops(stops);
        return linear;
    }

    private static Stop parseStop(Element ele) {
        Stop stop = new Stop();
        String co = ele.getAttribute("stop-color");
        stop.setColor(ColorRecognizer.recognizeColor(co, null));
        String opacity = ele.getAttribute("stop-opacity");
        if (opacity != null && !opacity.equals("")) {
            stop.setOpacity(Float.valueOf(opacity).floatValue());
        }
        stop.setOffset(Float.parseFloat(ele.getAttribute("offset").split("%")[0]));
        return stop;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LinearGradient) {
            LinearGradient linear = (LinearGradient)obj;
            if (this.getStops().size() == linear.getStops().size()) {
                int i = 0;
                while (i < this.getStops().size()) {
                    if (!this.getStops().get(i).equals(linear.getStops().get(i))) {
                        return false;
                    }
                    ++i;
                }
                return this.x1 == linear.x1 && this.y1 == linear.y1 && this.x2 == linear.x2 && this.y2 == linear.y2;
            }
        }
        return false;
    }

    public String toString() {
        return "Linear Gradient Color (" + this.getForeGroundColor().toString() + "-->" + this.getBackGroundColor().toString() + ")";
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + Float.floatToIntBits(this.x1);
        result = result * 31 + Float.floatToIntBits(this.y1);
        result = result * 31 + Float.floatToIntBits(this.x2);
        result = result * 31 + Float.floatToIntBits(this.y2);
        result = result * 31 + this.getForeGroundColor().hashCode();
        result = result * 31 + Float.floatToIntBits(this.getForeOpacity());
        result = result * 31 + this.getBackGroundColor().hashCode();
        result = result * 31 + Float.floatToIntBits(this.getBackOpacity());
        return result;
    }

    public SVGColor getForeGroundColor() {
        SVGColor foreground;
        if (this.isValidLinearGradient() && (foreground = this.getStops().get(0).getColor()) != null) {
            return foreground;
        }
        return FOREGROUND;
    }

    public float getForeOpacity() {
        if (this.isValidLinearGradient()) {
            return this.getStops().get(0).getOpacity();
        }
        return 1.0f;
    }

    public SVGColor getBackGroundColor() {
        SVGColor foreground;
        if (this.isValidLinearGradient() && (foreground = this.getStops().get(0).getColor()) != null) {
            return foreground;
        }
        return BACKGROUND;
    }

    public float getBackOpacity() {
        if (this.isValidLinearGradient()) {
            return this.getStops().get(1).getOpacity();
        }
        return 1.0f;
    }

    public float getX1() {
        return this.x1;
    }

    public float getX2() {
        return this.x2;
    }

    public float getY1() {
        return this.y1;
    }

    public float getY2() {
        return this.y2;
    }

    public void setStops(List<Stop> stops) {
        this.stops = stops;
    }

    public List<Stop> getStops() {
        return this.stops;
    }

    private boolean isValidLinearGradient() {
        return this.stops != null && this.stops.size() >= 2;
    }

    private static class Stop {
        private SVGColor color;
        private float offset;
        private float opacity = 1.0f;

        private Stop() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Stop) {
                Stop stop = (Stop)obj;
                return this.color.equals(stop.color) && this.opacity == stop.opacity && this.offset == stop.offset;
            }
            return false;
        }

        public SVGColor getColor() {
            return this.color;
        }

        public void setColor(SVGColor color) {
            this.color = color;
        }

        public void setOffset(float offset) {
            this.offset = offset;
        }

        public float getOpacity() {
            return this.opacity;
        }

        public void setOpacity(float opacity) {
            this.opacity = opacity;
        }
    }
}

