/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.internal.views.InspectorViewer;

public abstract class InspectorSection {
    private String sectionTitle;
    private IGraphicalViewer contributingViewer;
    private Section section;
    private InspectorViewer container = null;
    private ScrolledForm form;

    public InspectorSection() {
    }

    public InspectorSection(Control control) {
    }

    protected void setTitle(String title) {
        this.sectionTitle = title;
        if (this.section != null) {
            this.section.setText(title == null ? "" : title);
        }
    }

    public InspectorViewer getContainer() {
        return this.container;
    }

    public void setContainer(InspectorViewer container) {
        this.container = container;
    }

    public Composite createSectionControl(Composite parent, WidgetFactory factory, ScrolledForm form) {
        if (this.form != form) {
            this.form = form;
        }
        Composite composite = this.createComposite(parent, factory);
        this.fillSection(composite, factory);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                InspectorSection.this.handleDispose();
            }
        });
        return composite;
    }

    private Composite createComposite(Composite parent, WidgetFactory factory) {
        Composite composite = factory.createComposite(parent, 64);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.verticalSpacing = 7;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void fillSection(Composite parent, WidgetFactory factory) {
        if (parent == null || parent.isDisposed()) {
            return;
        }
        parent.setRedraw(true);
        this.section = factory.createSection(parent, 18754);
        if (this.sectionTitle != null) {
            this.section.setText(this.sectionTitle);
        }
        this.section.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite client = factory.createComposite((Composite)this.section, 64);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.verticalSpacing = 2;
        client.setLayout((Layout)layout);
        this.createContent(client);
        this.section.setClient((Control)client);
    }

    protected Composite createContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 7;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        return composite;
    }

    public void refresh() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (InspectorSection.this.getControl() == null || InspectorSection.this.getControl().isDisposed()) {
                    return;
                }
                InspectorSection.this.internalRefresh();
            }
        });
    }

    protected void internalRefresh() {
        this.refreshAuthorInfo();
        this.refreshList();
        this.refreshImageList();
        this.refreshFileInfo();
        if (this.section != null && !this.section.isDisposed()) {
            this.section.getParent().layout();
        }
    }

    protected void reflow() {
        if (this.form != null && !this.form.isDisposed()) {
            this.form.reflow(true);
        }
    }

    protected void refreshAuthorInfo() {
    }

    protected void refreshList() {
    }

    protected void refreshImageList() {
    }

    protected void refreshFileInfo() {
    }

    public boolean hasInspector() {
        return true;
    }

    public IGraphicalViewer getContributingViewer() {
        return this.contributingViewer;
    }

    protected IWorkbook getCurrentWorkbook() {
        if (this.contributingViewer == null) {
            return null;
        }
        return (IWorkbook)this.contributingViewer.getAdapter(IWorkbook.class);
    }

    protected ISheet getCurrentSheet() {
        if (this.contributingViewer == null) {
            return null;
        }
        return (ISheet)this.contributingViewer.getAdapter(ISheet.class);
    }

    protected List<ITopic> getAllTopics() {
        IWorkbook workBook = this.getCurrentWorkbook();
        if (workBook == null) {
            return null;
        }
        ArrayList<ITopic> allTopics = null;
        for (ISheet sheet : workBook.getSheets()) {
            if (allTopics == null) {
                allTopics = new ArrayList<ITopic>();
            }
            allTopics.addAll(this.getSheet(sheet));
        }
        return allTopics;
    }

    private List<ITopic> getSheet(ISheet sheet) {
        List<ITopic> allTopics = null;
        ITopic root = sheet.getRootTopic();
        if (root != null) {
            if (allTopics == null) {
                allTopics = new ArrayList<ITopic>();
            }
            allTopics.add(root);
            allTopics = this.getAllTopics(root.getAllChildren(), allTopics);
        }
        return allTopics;
    }

    private List<ITopic> getAllTopics(List<ITopic> topics, List<ITopic> allTopics) {
        if (topics.size() == 0) {
            return allTopics;
        }
        ArrayList<ITopic> subs = new ArrayList<ITopic>();
        for (ITopic topic : topics) {
            subs.addAll(topic.getAllChildren());
        }
        allTopics.addAll(topics);
        return this.getAllTopics(subs, allTopics);
    }

    public void setContributingViewer(IGraphicalViewer contributingViewer) {
        this.contributingViewer = contributingViewer;
        this.refresh();
    }

    public Control getControl() {
        return this.section;
    }

    protected abstract void handleDispose();

    protected Object[] getAllPropertyContents(IGraphicalViewer contributingViewer2) {
        return new Object[0];
    }

    protected Image getPropertyInspectorImage(Object element) {
        return null;
    }

    protected String getPropertyInspectorText(Object element) {
        return "";
    }

    protected class InspectorContentProvider
    implements IStructuredContentProvider {
        protected InspectorContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == InspectorSection.this.contributingViewer) {
                return InspectorSection.this.getAllPropertyContents(InspectorSection.this.contributingViewer);
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class InspectorLabelProvider
    extends LabelProvider {
        protected InspectorLabelProvider() {
        }

        public Image getImage(Object element) {
            return InspectorSection.this.getPropertyInspectorImage(element);
        }

        public String getText(Object element) {
            return InspectorSection.this.getPropertyInspectorText(element);
        }
    }
}

