/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2;

import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.xmind.core.ITopic;
import org.xmind.gef.GEF;
import org.xmind.ui.gantt2.viewer.GanttViewer;
import org.xmind.ui.gantt2.viewer.TaskBarViewer;

public class PrintGanttChartAction
extends Action {
    private static final int TASK_BAR_HORIZONTAL_MARGIN = 30;
    private GanttViewer viewer = null;
    private IFigure taskBarLayer;
    private IFigure dependencyLayer;
    private IFigure taskTreeLayer;
    private IFigure timelineLayer;
    private Rectangle paintArea;
    private Rectangle pageArea;
    private Rectangle totalArea;
    private Rectangle timelineBounds;
    private Rectangle timelineArea;
    private Rectangle taskTreeBounds;
    private Rectangle taskTreeArea;
    private Rectangle taskBarBounds;
    private Rectangle taskBarArea;
    private Color borderColor;

    public PrintGanttChartAction() {
        this.setText(WorkbenchMessages.Workbench_print);
        this.setToolTipText(WorkbenchMessages.Workbench_printToolTip);
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_PRINT_EDIT"));
        this.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_PRINT_EDIT_DISABLED"));
    }

    public void setGanttViewer(GanttViewer viewer) {
        this.viewer = viewer;
        this.setEnabled(viewer != null);
    }

    public void run() {
        if (this.viewer == null) {
            return;
        }
        Control c = this.viewer.getControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        TaskBarViewer taskBarViewer = this.viewer.getTaskBarViewer();
        this.taskBarLayer = taskBarViewer.getLayer(GEF.LAYER_CONTENTS);
        this.dependencyLayer = taskBarViewer.getLayer(TaskBarViewer.LAYER_DEPENDENCIES);
        this.taskTreeLayer = this.viewer.getTaskTreeViewer().getLayer(GEF.LAYER_CONTENTS);
        this.timelineLayer = this.viewer.getTimelineViewer().getLayer(GEF.LAYER_CONTENTS);
        if (this.taskBarLayer == null || this.dependencyLayer == null || this.taskTreeLayer == null || this.timelineLayer == null) {
            return;
        }
        PrintDialog dialog = new PrintDialog(c.getShell());
        PrinterData pd = dialog.open();
        if (pd == null) {
            return;
        }
        Printer printer = new Printer(pd);
        try {
            String jobName = ((ITopic)this.viewer.getInput()).getTitleText();
            if (printer.startJob(jobName)) {
                this.initPageAttributes(printer);
                while (this.pageArea != null) {
                    if (!printer.startPage()) continue;
                    this.paintPage(printer);
                    printer.endPage();
                }
                printer.endJob();
            }
        }
        finally {
            printer.dispose();
        }
    }

    private void initPageAttributes(Printer printer) {
        this.paintArea = new Rectangle(printer.getClientArea());
        this.timelineBounds = PrintGanttChartAction.union(this.timelineLayer).resize(0, 1);
        this.taskTreeBounds = PrintGanttChartAction.union(this.taskTreeLayer).resize(1, 0);
        this.taskBarBounds = PrintGanttChartAction.union(this.taskBarLayer, this.dependencyLayer).expand(30, 0);
        this.timelineBounds.x = this.taskBarBounds.x;
        this.timelineBounds.width = this.taskBarBounds.width;
        this.timelineArea = new Rectangle(this.timelineBounds);
        this.taskTreeArea = new Rectangle(this.taskTreeBounds);
        this.taskBarArea = new Rectangle(this.taskBarBounds);
        this.timelineArea.y = 0;
        this.taskTreeArea.x = 0;
        this.timelineArea.x = this.taskTreeArea.x + this.taskTreeArea.width;
        this.taskTreeArea.y = this.timelineArea.y + this.timelineArea.height;
        this.taskBarArea.setLocation(this.timelineArea.x, this.taskTreeArea.y);
        this.totalArea = PrintGanttChartAction.union(this.timelineArea, this.taskTreeArea, this.taskBarArea);
        this.pageArea = new Rectangle(this.paintArea);
        this.pageArea.setLocation(this.totalArea.x, this.totalArea.y);
        this.borderColor = printer.getSystemColor(15);
    }

    private static Rectangle union(Object ... figures) {
        Rectangle r = null;
        Object[] objectArray = figures;
        int n = figures.length;
        int n2 = 0;
        while (n2 < n) {
            Object figure = objectArray[n2];
            if (r == null) {
                r = new Rectangle(PrintGanttChartAction.getBoundingBox(figure));
            } else {
                r.union(PrintGanttChartAction.getBoundingBox(figure));
            }
            ++n2;
        }
        return r;
    }

    private static Rectangle getBoundingBox(Object obj) {
        if (obj instanceof Rectangle) {
            return (Rectangle)obj;
        }
        if (obj instanceof FreeformFigure) {
            return ((FreeformFigure)obj).getFreeformExtent();
        }
        return ((IFigure)obj).getBounds();
    }

    private void paintPage(Printer printer) {
        GC gc = new GC((Drawable)printer);
        try {
            SWTGraphics graphics = new SWTGraphics(gc);
            try {
                this.paintPageContent((Graphics)graphics);
            }
            finally {
                graphics.dispose();
            }
        }
        finally {
            gc.dispose();
        }
    }

    private void paintPageContent(Graphics graphics) {
        graphics.setLineWidthFloat(1.0f);
        graphics.setForegroundColor(this.borderColor);
        graphics.clipRect(this.paintArea);
        graphics.translate(this.paintArea.x - this.pageArea.x, this.paintArea.y - this.pageArea.y);
        graphics.drawRectangle(this.totalArea.x, this.totalArea.y, this.totalArea.width - 1, this.totalArea.height - 1);
        graphics.drawLine(this.totalArea.x, this.taskTreeArea.y - 1, this.totalArea.x + this.totalArea.width, this.taskTreeArea.y - 1);
        graphics.drawLine(this.timelineArea.x - 1, this.totalArea.y, this.timelineArea.x - 1, this.totalArea.y + this.totalArea.height);
        this.paintFigures(graphics, this.timelineArea, this.timelineBounds, this.timelineLayer);
        this.paintFigures(graphics, this.taskTreeArea, this.taskTreeBounds, this.taskTreeLayer);
        this.paintFigures(graphics, this.taskBarArea, this.taskBarBounds, this.taskBarLayer, this.dependencyLayer);
        if (this.pageArea.y + this.pageArea.height < this.totalArea.y + this.totalArea.height) {
            this.pageArea.y += this.pageArea.height;
        } else {
            this.pageArea.x += this.pageArea.width;
            this.pageArea.y = this.totalArea.y;
        }
        if (this.pageArea.x > this.totalArea.x + this.totalArea.width) {
            this.pageArea = null;
        }
    }

    private void paintFigures(Graphics graphics, Rectangle area, Rectangle bounds, IFigure ... figures) {
        if (this.pageArea.intersects(area)) {
            graphics.pushState();
            graphics.translate(area.x - bounds.x, area.y - bounds.y);
            graphics.pushState();
            IFigure[] iFigureArray = figures;
            int n = figures.length;
            int n2 = 0;
            while (n2 < n) {
                IFigure figure = iFigureArray[n2];
                this.paintFigure(graphics, figure);
                ++n2;
            }
            graphics.popState();
            graphics.popState();
        }
    }

    private void paintFigure(Graphics graphics, IFigure figure) {
        figure.paint(graphics);
        graphics.restoreState();
    }
}

