/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.gefext;

import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.LayoutManager;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.IAnchorListener;
import org.xmind.ui.gantt2.gefext.IConnectionRouter;
import org.xmind.ui.gantt2.gefext.IPathConnection;
import org.xmind.ui.gantt2.gefext.PathShape;

public class PathConnection
extends PathShape
implements IPathConnection,
IAnchorListener {
    private IAnchor sourceAnchor;
    private IAnchor targetAnchor;
    private IConnectionRouter router = null;
    private boolean realized = false;

    public PathConnection() {
        this.setAntialias(1);
        this.setOutline(true);
        this.setFill(false);
        this.setLayoutManager((LayoutManager)new DelegatingLayout());
    }

    public IAnchor getSourceAnchor() {
        return this.sourceAnchor;
    }

    public IAnchor getTargetAnchor() {
        return this.targetAnchor;
    }

    public void setSourceAnchor(IAnchor anchor) {
        if (anchor == this.sourceAnchor) {
            return;
        }
        this.unhookSourceAnchor();
        this.sourceAnchor = anchor;
        if (this.realized) {
            this.hookSourceAnchor();
        }
        this.revalidate();
    }

    public void setTargetAnchor(IAnchor anchor) {
        if (anchor == this.targetAnchor) {
            return;
        }
        this.unhookTargetAnchor();
        this.targetAnchor = anchor;
        if (this.realized) {
            this.hookTargetAnchor();
        }
        this.revalidate();
    }

    protected void hookSourceAnchor() {
        if (this.getSourceAnchor() != null) {
            this.getSourceAnchor().addAnchorListener((IAnchorListener)this);
        }
    }

    protected void unhookSourceAnchor() {
        if (this.getSourceAnchor() != null) {
            this.getSourceAnchor().removeAnchorListener((IAnchorListener)this);
        }
    }

    protected void hookTargetAnchor() {
        if (this.getTargetAnchor() != null) {
            this.getTargetAnchor().addAnchorListener((IAnchorListener)this);
        }
    }

    protected void unhookTargetAnchor() {
        if (this.getTargetAnchor() != null) {
            this.getTargetAnchor().removeAnchorListener((IAnchorListener)this);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.realized = true;
        this.hookSourceAnchor();
        this.hookTargetAnchor();
    }

    public void removeNotify() {
        super.removeNotify();
        this.realized = false;
        this.unhookSourceAnchor();
        this.unhookTargetAnchor();
    }

    public void setConnectionRouter(IConnectionRouter router) {
        if (router == this.router) {
            return;
        }
        if (this.router != null) {
            this.router.invalidate(this);
        }
        this.router = router;
        if (router != null) {
            router.invalidate(this);
        }
        this.revalidate();
    }

    public IConnectionRouter getConnectionRouter() {
        return this.router;
    }

    public void anchorMoved(IAnchor anchor) {
        this.revalidate();
    }

    public boolean containsPoint(int x, int y) {
        if (this.getConnectionRouter() == null) {
            return false;
        }
        return super.containsPoint(x, y);
    }

    public void invalidate() {
        super.invalidate();
        if (this.router != null) {
            this.router.invalidate(this);
        }
    }

    protected void layout() {
        if (this.router != null) {
            this.router.route(this);
        }
        super.layout();
    }
}

