/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.audio.internal.device;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.sound.sampled.TargetDataLine;
import org.eclipse.core.runtime.Platform;
import org.xmind.core.audio.IAudioDevice;
import org.xmind.core.audio.IAudioSource;
import org.xmind.core.audio.IAudioTarget;
import org.xmind.core.audio.internal.device.LameMP3Recorder;
import org.xmind.core.audio.internal.device.RawDataChannel;
import org.xmind.core.audio.internal.device.RawDataRecorder;

public class LameMP3Channel
extends RawDataChannel {
    private static final boolean DEBUG = RawDataRecorder.DEBUG;
    private static final String VBR = "9";
    private OutputStream realOutput;
    private File tempRawFile;
    private File tempMp3File;
    private String lameExecutablePath;

    public LameMP3Channel(IAudioDevice device, IAudioSource source, IAudioTarget target, TargetDataLine line, OutputStream output, File tempRawFile, File tempMp3File, OutputStream tempOutput, String lamePath) {
        super(device, source, target, line, tempOutput);
        this.realOutput = output;
        this.tempRawFile = tempRawFile;
        this.tempMp3File = tempMp3File;
        this.lameExecutablePath = lamePath;
    }

    protected String getJobName() {
        return "Record MP3 File";
    }

    protected void encode() throws Exception {
        ProcessBuilder builder;
        block27: {
            if (DEBUG) {
                System.out.println("[LameMP3Channel] Start Building Encoding Process");
            }
            if (!this.tempRawFile.exists() || !this.tempRawFile.canRead()) {
                throw new FileNotFoundException();
            }
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(this.lameExecutablePath);
            commands.add("-S");
            commands.add("-r");
            if (LameMP3Recorder.MONO) {
                commands.add("-m");
                commands.add("m");
            }
            commands.add("-s");
            commands.add(String.format("%.1f", Float.valueOf(LameMP3Recorder.getFormat().getSampleRate() / 1000.0f)));
            commands.add("--bitwidth");
            commands.add(Integer.toString(16));
            commands.add("-f");
            commands.add("-V");
            commands.add(VBR);
            commands.add(this.tempRawFile.getAbsolutePath());
            commands.add(this.tempMp3File.getAbsolutePath());
            if (DEBUG) {
                System.out.println(commands);
            }
            builder = new ProcessBuilder(commands.toArray(new String[0]));
            if (DEBUG) {
                System.out.println("[LameMP3Channel] Start Encoding Process");
            }
            try {
                if ("macosx".equals(Platform.getOS())) {
                    Runtime.getRuntime().exec("chmod +x " + this.lameExecutablePath);
                }
                Thread.sleep(500L);
            }
            catch (Throwable e) {
                if (!DEBUG) break block27;
                e.printStackTrace();
            }
        }
        Process encodeProcess = builder.start();
        try {
            encodeProcess.waitFor();
        }
        finally {
            encodeProcess.destroy();
        }
        if (DEBUG) {
            System.out.println("[LameMP3Channel] Start Copy Temp MP3 File to Target Output Stream");
        }
        FileInputStream mp3Input = new FileInputStream(this.tempMp3File);
        try {
            byte[] buffer = new byte[1024];
            try {
                int num;
                while ((num = mp3Input.read(buffer)) > 0) {
                    this.realOutput.write(buffer, 0, num);
                }
                this.realOutput.flush();
            }
            catch (Throwable throwable) {
                try {
                    this.realOutput.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                this.realOutput.close();
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            try {
                mp3Input.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            mp3Input.close();
        }
        catch (IOException iOException) {}
        if (!DEBUG) {
            this.tempRawFile.delete();
            this.tempMp3File.delete();
        }
        if (DEBUG) {
            System.out.println("[LameMP3Channel] Encoding Ended");
        }
    }
}

