/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.verify.internal;

import org.xmind.core.licensing.ILicenseKeyHeader;

public class LicenseKeyHeader2
implements ILicenseKeyHeader {
    private final String encoded;
    private final String type;
    private final String vendorName;
    private final int majorVersion;
    private final int minorVersion;
    private final String licenseeType;
    private final int yearsOfUpgrade;
    private final int freeMonths;

    private LicenseKeyHeader2(String encoded, String type, String vendorName, int majorVersion, int minorVersion, String licenseeType, int yearsOfUpgrade, int freeMonths) {
        this.encoded = encoded;
        this.type = type;
        this.vendorName = vendorName;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.licenseeType = licenseeType;
        this.yearsOfUpgrade = yearsOfUpgrade;
        this.freeMonths = freeMonths;
    }

    public String getLicenseType() {
        return this.type;
    }

    public int getMajorVersionNumber() {
        return this.majorVersion;
    }

    public int getMinorVersionNumber() {
        return this.minorVersion;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public String getLicenseeType() {
        return this.licenseeType;
    }

    public int getYearsOfUpgrade() {
        return this.yearsOfUpgrade;
    }

    public int getFreeMonths() {
        return this.freeMonths;
    }

    public String toEncoded() {
        return this.encoded;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(512);
        builder.append("LicenseKeyHeader{");
        builder.append(this.encoded);
        builder.append(",type=");
        builder.append(this.type);
        builder.append(",vendor=");
        builder.append(this.vendorName);
        builder.append(",version=");
        builder.append(this.majorVersion);
        builder.append('.');
        builder.append(this.minorVersion);
        builder.append(",licenseeType=");
        builder.append(this.licenseeType);
        builder.append(",yearsOfUpgrade=");
        builder.append(this.yearsOfUpgrade);
        builder.append('}');
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof LicenseKeyHeader2)) {
            return false;
        }
        LicenseKeyHeader2 that = (LicenseKeyHeader2)obj;
        return this.encoded.equals(that.encoded);
    }

    public int hashCode() {
        return this.encoded.hashCode();
    }

    public static LicenseKeyHeader2 decode(String header) throws IllegalArgumentException {
        if (header.length() != 12) {
            throw new IllegalArgumentException("Invalid length of license key header: " + header.length());
        }
        String marker = header.substring(0, 1);
        if (!"X".equals(marker)) {
            throw new IllegalArgumentException("Invalid license key header: " + header);
        }
        String type = header.substring(1, 2);
        String vendorName = header.substring(2, 4);
        int majorVersion = Integer.parseInt(header.substring(4, 5), 36);
        int minorVersion = Integer.parseInt(header.substring(5, 6), 36);
        String licenseeType = header.substring(6, 7);
        int yearsOfUpgrade = Integer.parseInt(header.substring(7, 9), 36);
        int freeMonths = LicenseKeyHeader2.decodeFreeMonthsFromHeader(header);
        return new LicenseKeyHeader2(header, type, vendorName, majorVersion, minorVersion, licenseeType, yearsOfUpgrade, freeMonths);
    }

    private static int decodeFreeMonthsFromHeader(String header) {
        char encodedFreeMonths = header.toLowerCase().charAt(9);
        int freeMonths = encodedFreeMonths > '`' ? encodedFreeMonths - 87 : encodedFreeMonths - 48;
        return freeMonths;
    }
}

