/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.imports.mm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IBoundary;
import org.xmind.core.IFileEntry;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.IIdentifiable;
import org.xmind.core.IImage;
import org.xmind.core.IImageSpan;
import org.xmind.core.ILegend;
import org.xmind.core.INotesContent;
import org.xmind.core.INumbering;
import org.xmind.core.IParagraph;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ISpan;
import org.xmind.core.ISummary;
import org.xmind.core.ITitled;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.dom.NumberUtils;
import org.xmind.core.internal.dom.StyleSheetImpl;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.io.ResourceMappingManager;
import org.xmind.core.io.mindmanager.MMConstants;
import org.xmind.core.io.mindmanager.MMResourceMappingManager;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.style.IStyled;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.imports.ImportMessages;
import org.xmind.ui.internal.imports.ImporterUtils;
import org.xmind.ui.internal.protocols.FilePathParser;
import org.xmind.ui.io.MonitoredInputStream;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.wizards.MindMapImporter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MindManagerImporter
extends MindMapImporter
implements MMConstants,
ErrorHandler {
    private static final Pattern DATE_PATTERN = Pattern.compile("((\\d+)-(\\d{1,2})-(\\d{1,2}))T((\\d{1,2}):(\\d{1,2}):(\\d{1,2}))");
    private static final String TRANSPARENT_VALUE = "0.00";
    private static Pattern OID_PATTERN = null;
    private static final String DOCUMENT_XML = "Document.xml";
    private static final double DPM = 2.834645669291339;
    private static ResourceMappingManager mappings = null;
    private IStorage tempStorage;
    private IInputSource tempSource;
    private ISheet targetSheet;
    private Map<String, String> idMap = new HashMap<String, String>(30);
    private IStyleSheet tempStyleSheet = null;
    private Map<IStyled, IStyle> styleMap = new HashMap<IStyled, IStyle>(30);
    private IStyle theme = null;
    private Map<String, List<ITopic>> topicLinkMap = new HashMap<String, List<ITopic>>(10);
    private static final String NUMBER_FORMAT_NONE = "org.xmind.numbering.none";
    private static final String NUMBER_FORMAT_ARABIC = "org.xmind.numbering.arabic";
    private static final String NUMBER_FORMAT_ROMAN = "org.xmind.numbering.roman";
    private static final String NUMBER_FORMAT_LOWERCASE = "org.xmind.numbering.lowercase";
    private static final String NUMBER_FORMAT_UPPERCASE = "org.xmind.numbering.uppercase";
    private Map<ITopic, Element> numberingEles;

    public MindManagerImporter(String sourcePath) {
        super(sourcePath);
    }

    public MindManagerImporter(String sourcePath, IWorkbook targetWorkbook) {
        super(sourcePath, targetWorkbook);
    }

    public void build() throws InvocationTargetException, InterruptedException {
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ImportFromMindManagerCount");
        this.getMonitor().beginTask(null, 100);
        try {
            try {
                this.getMonitor().subTask(ImportMessages.MindManagerImporter_ReadingContent);
                this.tempStorage = this.createTemporaryStorage();
                this.extractSourceFileToTemporaryStorage();
                this.tempSource = this.tempStorage.getInputSource();
                Document doc = this.readContents();
                this.getMonitor().worked(45);
                this.checkInterrupted();
                this.getMonitor().subTask(ImportMessages.MindManagerImporter_ReadingElements);
                this.loadSheet(doc.getDocumentElement());
                this.setTopicLinks();
                this.getMonitor().worked(45);
                this.checkInterrupted();
                this.getMonitor().subTask(ImportMessages.MindManagerImporter_ArrangingStyles);
                this.arrangeStyles();
                this.getMonitor().worked(5);
                this.checkInterrupted();
                this.getMonitor().subTask(ImportMessages.MindManagerImporter_GeneratingTheme);
                this.generateTheme();
                this.getMonitor().worked(5);
                this.getMonitor().done();
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            this.clearTempStorage();
        }
        this.postBuilded();
    }

    private Document readContents() throws Exception {
        Document doc;
        InputStream docEntryStream = this.tempSource.getEntryStream(DOCUMENT_XML);
        if (docEntryStream == null) {
            throw new IOException("No content entry");
        }
        DocumentBuilder builder = MindManagerImporter.getDocumentBuilder();
        builder.setErrorHandler(this);
        MonitoredInputStream in = new MonitoredInputStream(docEntryStream, this.getMonitor());
        try {
            doc = builder.parse((InputStream)in);
        }
        catch (Throwable throwable) {
            builder.setErrorHandler(null);
            try {
                in.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        builder.setErrorHandler(null);
        try {
            in.close();
        }
        catch (Exception exception) {}
        return doc;
    }

    private IStorage createTemporaryStorage() throws IOException {
        String id = String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS", System.currentTimeMillis());
        File tempDir = FileUtils.ensureDirectory((File)new File(Core.getWorkspace().getTempDir("import/mindmanager"), id));
        return new DirectoryStorage(tempDir);
    }

    private void extractSourceFileToTemporaryStorage() throws IOException, CoreException {
        FileInputStream fin = new FileInputStream(this.getSourcePath());
        try {
            ZipInputStream zin = new ZipInputStream((InputStream)new MonitoredInputStream((InputStream)new BufferedInputStream(fin), this.getMonitor()));
            try {
                FileUtils.extractZipFile((ZipInputStream)zin, (IOutputTarget)this.tempStorage.getOutputTarget());
            }
            finally {
                zin.close();
            }
        }
        finally {
            fin.close();
        }
    }

    private void checkInterrupted() throws InterruptedException {
        if (this.getMonitor().isCanceled()) {
            throw new InterruptedException();
        }
    }

    private void clearTempStorage() {
        if (this.tempStorage != null) {
            this.tempStorage.clear();
            this.tempStorage = null;
        }
    }

    private void loadSheet(Element docEle) throws InterruptedException {
        Element markersGroupEle;
        Element styleGroupEle;
        Element relsEle;
        this.checkInterrupted();
        this.targetSheet = this.getTargetWorkbook().createSheet();
        this.targetSheet.setTitleText(this.getSuggestedSheetTitle());
        Element oneTopicEle = MindManagerImporter.child(docEle, "OneTopic");
        if (oneTopicEle != null) {
            this.loadRootTopic(oneTopicEle);
        }
        if ((relsEle = MindManagerImporter.child(docEle, "Relationships")) != null) {
            this.loadRelationships(relsEle);
        }
        if ((styleGroupEle = MindManagerImporter.child(docEle, "StyleGroup")) != null) {
            this.loadStyleGroup(styleGroupEle);
        }
        if ((markersGroupEle = MindManagerImporter.child(docEle, "MarkersSetGroup")) != null) {
            this.loadMarkersGroup(markersGroupEle);
        }
        this.addTargetSheet(this.targetSheet);
    }

    public ISheet getTargetSheet() {
        return this.targetSheet;
    }

    private void arrangeStyles() throws InterruptedException {
        IStyleSheet targetStyleSheet = this.getTargetWorkbook().getStyleSheet();
        for (Map.Entry<IStyled, IStyle> en : this.styleMap.entrySet()) {
            this.checkInterrupted();
            IStyled styleOwner = en.getKey();
            IStyle style = en.getValue();
            IStyle importedStyle = targetStyleSheet.importStyle(style);
            if (importedStyle == null) continue;
            styleOwner.setStyleId(importedStyle.getId());
        }
    }

    private void loadMarkersGroup(Element markersGroupEle) throws InterruptedException {
        this.checkInterrupted();
        ILegend legend = this.getTargetSheet().getLegend();
        Element markersSetsEle = MindManagerImporter.child(markersGroupEle, "ap:IconMarkersSets");
        if (markersSetsEle != null) {
            Iterator<Element> it = MindManagerImporter.children(markersSetsEle, "ap:IconMarkersSet");
            while (it.hasNext()) {
                this.checkInterrupted();
                Element markersSetEle = it.next();
                this.loadLegendMarkers(markersSetEle, legend, "ap:IconMarkers", "ap:IconMarker", "ap:OneStockIcon", "IconType");
            }
        }
        this.loadLegendMarkers(markersGroupEle, legend, "ap:IconMarkers", "ap:IconMarker", "ap:OneStockIcon", "IconType");
        this.loadLegendMarkers(markersGroupEle, legend, "ap:TaskPercentageMarkers", "ap:TaskPercentageMarker", "ap:TaskPercentage", "TaskPercentage");
        this.loadLegendMarkers(markersGroupEle, legend, "ap:TaskPriorityMarkers", "ap:TaskPriorityMarker", "ap:TaskPriority", "TaskPriority");
    }

    private void loadLegendMarkers(Element markersSetEle, ILegend legend, String markersEleName, String markerEleName, String iconEleName, String iconAttrName) throws InterruptedException {
        this.checkInterrupted();
        Element markersEle = MindManagerImporter.child(markersSetEle, markersEleName);
        if (markersEle != null) {
            this.loadLegendMarkers(markersEle, legend, markerEleName, iconEleName, iconAttrName);
        }
    }

    private void loadLegendMarkers(Element markersEle, ILegend legend, String markerEleName, String iconEleName, String iconAttrName) throws InterruptedException {
        this.checkInterrupted();
        Iterator<Element> it = MindManagerImporter.children(markersEle, markerEleName);
        while (it.hasNext()) {
            String markerId;
            String type;
            this.checkInterrupted();
            Element markerEle = it.next();
            Element iconEle = MindManagerImporter.child(markerEle, iconEleName);
            if (iconEle == null || (type = MindManagerImporter.att(iconEle, iconAttrName)) == null || (markerId = MindManagerImporter.getMapping("marker", type, null)) == null) continue;
            String name = MindManagerImporter.loadName(markerEle);
            legend.setMarkerDescription(markerId, name);
        }
    }

    private static String loadName(Element parentEle) {
        return MindManagerImporter.loadName(parentEle, null);
    }

    private static String loadName(Element parentEle, String eleName) {
        Element ele;
        if (eleName == null) {
            eleName = "ap:Name";
        }
        if ((ele = MindManagerImporter.child(parentEle, eleName)) != null) {
            return MindManagerImporter.att(ele, "Name");
        }
        return null;
    }

    private void loadStyleGroup(Element styleGroupEle) throws InterruptedException {
        this.checkInterrupted();
        this.loadTopicTheme(styleGroupEle);
        this.loadRelTheme(styleGroupEle);
        this.loadBoundaryTheme(styleGroupEle);
        this.loadSheetStyle(styleGroupEle);
    }

    private void loadSheetStyle(Element styleGroupEle) throws InterruptedException {
        IFileEntry entry;
        String uri;
        Element bgImgEle;
        String fillColor;
        Element bgFillEle;
        Float lineWidth;
        this.checkInterrupted();
        ISheet sheet = this.getTargetSheet();
        Element structureEle = MindManagerImporter.child(styleGroupEle, "ap:Structure");
        if (structureEle != null && (lineWidth = MindManagerImporter.parseFloat(MindManagerImporter.att(structureEle, "MainTopicLineWidth"))) != null && lineWidth.floatValue() > 3.0f) {
            this.registerStyle((IStyled)sheet, "line-tapered", "tapered");
        }
        if ((bgFillEle = MindManagerImporter.child(styleGroupEle, "ap:BackgroundFill")) != null && (fillColor = MindManagerImporter.parseColor(MindManagerImporter.att(bgFillEle, "FillColor"))) != null) {
            this.registerStyle((IStyled)sheet, "svg:fill", fillColor);
        }
        if ((bgImgEle = MindManagerImporter.child(styleGroupEle, "ap:BackgroundImageData")) != null && (uri = MindManagerImporter.loadUri(bgImgEle)) != null && (entry = this.loadAttachment(null, uri, "*.png")) != null && entry.getSize() > 0L) {
            this.registerStyle((IStyled)sheet, "background", HyperlinkUtils.toAttachmentURL((String)entry.getPath()));
            int transparency = NumberUtils.safeParseInt((String)MindManagerImporter.att(bgImgEle, "Transparency"), (int)-1);
            if (transparency >= 0) {
                double opacity = (double)(100 - transparency) * 1.0 / 100.0;
                this.registerStyle((IStyled)sheet, "svg:opacity", String.format("%.2f", opacity));
            }
        }
    }

    private void loadBoundaryTheme(Element styleGroupEle) throws InterruptedException {
        this.checkInterrupted();
        Element parentEle = MindManagerImporter.child(styleGroupEle, "ap:BoundaryDefaultsGroup");
        if (parentEle == null) {
            return;
        }
        this.loadThemeColor(parentEle, true, true, true, "boundary", "boundary");
        this.loadThemeLineStyle(parentEle, "boundary", "boundary");
        this.loadThemeBoundaryShape(parentEle, "boundary");
    }

    private void loadThemeBoundaryShape(Element parentEle, String styleFamily) throws InterruptedException {
        this.checkInterrupted();
        Element ele = MindManagerImporter.child(parentEle, "ap:DefaultBoundaryShape");
        if (ele == null) {
            return;
        }
        String shape = MindManagerImporter.parseBoundaryShape(MindManagerImporter.att(ele, "BoundaryShape"));
        this.registerTheme("boundary", styleFamily, "shape-class", shape);
    }

    private void loadThemeLineStyle(Element parentEle, String type, String styleFamily) throws InterruptedException {
        this.checkInterrupted();
        Element ele = MindManagerImporter.child(parentEle, "ap:DefaultLineStyle");
        if (ele == null) {
            return;
        }
        String linePattern = MindManagerImporter.parseLinePattern(MindManagerImporter.att(ele, "LineDashStyle"));
        this.registerTheme(type, styleFamily, "line-pattern", linePattern);
        String lineWidth = MindManagerImporter.parseLineWidth(MindManagerImporter.att(ele, "LineWidth"));
        this.registerTheme(type, styleFamily, "line-width", lineWidth);
    }

    private void loadRelTheme(Element styleGroupEle) throws InterruptedException {
        this.checkInterrupted();
        Element parentEle = MindManagerImporter.child(styleGroupEle, "ap:RelationshipDefaultsGroup");
        if (parentEle == null) {
            return;
        }
        this.loadThemeColor(parentEle, false, false, true, "relationship", "relationship");
        this.loadThemeLineStyle(parentEle, "relationship", "relationship");
        this.loadThemeArrowStyle(parentEle, "relationship");
        this.loadThemeRelShape(parentEle, "relationship");
    }

    private void loadThemeRelShape(Element parentEle, String styleFamily) throws InterruptedException {
        this.checkInterrupted();
        Element relShapeEle = MindManagerImporter.child(parentEle, "ap:DefaultRelationshipLineShape");
        if (relShapeEle == null) {
            return;
        }
        String shape = MindManagerImporter.parseRelationshipShape(MindManagerImporter.att(relShapeEle, "LineShape"));
        this.registerTheme("relationship", styleFamily, "shape-class", shape);
    }

    private void loadThemeArrowStyle(Element parentEle, String styleFamily) throws InterruptedException {
        this.checkInterrupted();
        Iterator<Element> it = MindManagerImporter.children(parentEle, "ap:DefaultConnectionStyle");
        while (it.hasNext()) {
            String shape;
            this.checkInterrupted();
            Element ele = it.next();
            int index = NumberUtils.safeParseInt((String)MindManagerImporter.att(ele, "Index"), (int)-1);
            if (index != 0 && index != 1 || (shape = MindManagerImporter.parseConnShape(MindManagerImporter.att(ele, "ConnectionShape"))) == null) continue;
            String styleKey = index == 0 ? "arrow-begin-class" : "arrow-end-class";
            this.registerTheme("relationship", styleFamily, styleKey, shape);
        }
    }

    private void loadThemeColor(Element parentEle, boolean fill, boolean fillAlpha, boolean line, String type, String styleFamily) throws InterruptedException {
        this.checkInterrupted();
        Element colorEle = MindManagerImporter.child(parentEle, "ap:DefaultColor");
        if (colorEle == null) {
            return;
        }
        if (fill || fillAlpha) {
            String fillColor = MindManagerImporter.att(colorEle, "FillColor");
            if (fill) {
                this.registerTheme(type, styleFamily, "svg:fill", MindManagerImporter.parseColor(fillColor));
            }
            if (fillAlpha) {
                this.registerTheme(type, styleFamily, "svg:opacity", MindManagerImporter.parseAlpha(fillColor));
            }
        }
        if (line) {
            String lineColor = MindManagerImporter.att(colorEle, "LineColor");
            this.registerTheme(type, styleFamily, "line-color", MindManagerImporter.parseColor(lineColor));
        }
    }

    private void loadTopicTheme(Element styleGroupEle) throws InterruptedException {
        Element floatingEle;
        this.checkInterrupted();
        Element rootEle = MindManagerImporter.child(styleGroupEle, "ap:RootTopicDefaultsGroup");
        if (rootEle != null) {
            this.loadTopicTheme(rootEle, null, null, "centralTopic");
        }
        int deepestLevel = 0;
        Element realSubEle = null;
        Iterator<Element> it = MindManagerImporter.children(rootEle, "ap:RootSubTopicDefaultsGroup");
        while (it.hasNext()) {
            Element subEle = it.next();
            int level = NumberUtils.safeParseInt((String)MindManagerImporter.att(subEle, "Level"), (int)-1);
            if (level == 0) {
                this.loadTopicTheme(subEle, null, null, "mainTopic");
                continue;
            }
            if (level <= 0 || level <= deepestLevel) continue;
            deepestLevel = level;
            realSubEle = subEle;
        }
        if (realSubEle != null) {
            this.loadTopicTheme(realSubEle, null, null, "subTopic");
        }
        if ((floatingEle = MindManagerImporter.child(styleGroupEle, "ap:LabelTopicDefaultsGroup")) != null) {
            this.loadTopicTheme(floatingEle, "ap:DefaultLabelFloatingTopicShape", "LabelFloatingTopicShape", "floatingTopic");
        }
    }

    private void loadTopicTheme(Element parentEle, String shapeEleName, String shapeAttrName, String styleFamily) throws InterruptedException {
        this.checkInterrupted();
        this.loadThemeColor(parentEle, true, false, true, "topic", styleFamily);
        this.loadThemeTextStyle(parentEle, styleFamily);
        this.loadThemeTopicShape(parentEle, shapeEleName, shapeAttrName, styleFamily);
        this.loadThemeBranchStyle(parentEle, styleFamily);
    }

    private void loadThemeBranchStyle(Element parentEle, String styleFamily) throws InterruptedException {
        this.checkInterrupted();
        Element ele = MindManagerImporter.child(parentEle, "ap:DefaultSubTopicsShape");
        if (ele == null) {
            return;
        }
        String branchConn = MindManagerImporter.parseBranchConn(MindManagerImporter.att(ele, "SubTopicsConnectionStyle"));
        this.registerTheme("topic", styleFamily, "line-class", branchConn);
    }

    private static String parseBranchConn(String connStyle) {
        return MindManagerImporter.getMapping("branchConnection", connStyle, null);
    }

    private void loadThemeTopicShape(Element parentEle, String shapeEleName, String shapeAttrName, String styleFamily) throws InterruptedException {
        Element shapeEle;
        this.checkInterrupted();
        if (shapeEleName == null) {
            shapeEleName = "ap:DefaultSubTopicShape";
        }
        if ((shapeEle = MindManagerImporter.child(parentEle, shapeEleName)) == null) {
            return;
        }
        if (shapeAttrName == null) {
            shapeAttrName = "SubTopicShape";
        }
        String shape = MindManagerImporter.parseTopicShape(MindManagerImporter.att(shapeEle, shapeAttrName));
        this.registerTheme("topic", styleFamily, "shape-class", shape);
    }

    private void loadThemeTextStyle(Element parentEle, String themeKey) throws InterruptedException {
        this.checkInterrupted();
        Element textEle = MindManagerImporter.child(parentEle, "ap:Text");
        if (textEle == null) {
            return;
        }
        this.loadThemeFont(textEle, "topic", themeKey);
    }

    private void loadThemeFont(Element parentEle, String type, String styleFamily) throws InterruptedException {
        this.checkInterrupted();
        Element fontEle = MindManagerImporter.child(parentEle, "ap:Font");
        if (fontEle == null) {
            return;
        }
        String color = MindManagerImporter.parseColor(MindManagerImporter.att(fontEle, "Color"));
        this.registerTheme(type, styleFamily, "fo:color", color);
        String fontName = MindManagerImporter.att(fontEle, "Name");
        String availableFontName = FontUtils.getAAvailableFontNameFor((String)fontName);
        fontName = availableFontName != null ? availableFontName : fontName;
        this.registerTheme(type, styleFamily, "fo:font-family", fontName);
        String size = MindManagerImporter.att(fontEle, "Size");
        this.registerTheme(type, styleFamily, "fo:font-size", size);
        String bold = MindManagerImporter.att(fontEle, "Bold");
        this.registerTheme(type, styleFamily, "fo:font-weight", Boolean.parseBoolean(bold) ? "bold" : null);
        String italic = MindManagerImporter.att(fontEle, "Italic");
        this.registerTheme(type, styleFamily, "fo:font-style", Boolean.parseBoolean(italic) ? "italic" : null);
        boolean underline = Boolean.parseBoolean(MindManagerImporter.att(fontEle, "Underline"));
        boolean strikeout = Boolean.parseBoolean(MindManagerImporter.att(fontEle, "Strikethrough"));
        this.registerTheme(type, styleFamily, "fo:text-decoration", StyleUtils.toTextDecoration((boolean)underline, (boolean)strikeout));
    }

    private void registerTheme(String type, String styleFamily, String styleKey, String styleValue) throws InterruptedException {
        IStyle defaultStyle;
        this.checkInterrupted();
        if (styleFamily == null || styleKey == null || styleValue == null) {
            return;
        }
        if (this.theme == null) {
            this.theme = this.getTempStyleSheet().createStyle("theme");
            this.getTempStyleSheet().addStyle(this.theme, "master-styles");
        }
        if ((defaultStyle = this.theme.getDefaultStyle(styleFamily)) == null) {
            defaultStyle = this.getTempStyleSheet().createStyle(type);
            this.getTempStyleSheet().addStyle(defaultStyle, "automatic-styles");
        }
        defaultStyle.setProperty(styleKey, styleValue);
    }

    private void generateTheme() throws InterruptedException {
        IStyle importedTheme;
        this.checkInterrupted();
        if (this.theme != null && (importedTheme = this.getTargetWorkbook().getStyleSheet().importStyle(this.theme)) != null) {
            this.getTargetSheet().setThemeId(importedTheme.getId());
        }
    }

    private void loadRelationships(Element relsEle) throws InterruptedException {
        this.checkInterrupted();
        Iterator<Element> it = MindManagerImporter.children(relsEle, "ap:Relationship");
        while (it.hasNext()) {
            Element relEle = it.next();
            this.loadRelationship(relEle);
        }
    }

    private void loadRelationship(Element relEle) throws InterruptedException {
        this.checkInterrupted();
        IRelationship rel = this.getTargetWorkbook().createRelationship();
        this.getTargetSheet().addRelationship(rel);
        this.loadOId(relEle, (IIdentifiable)rel);
        boolean autoRouting = this.loadAutoRouting(relEle);
        this.loadConnections(relEle, rel, autoRouting);
        this.loadLineStyle(relEle, (IStyled)rel);
        this.loadRelLineShape(relEle, rel);
    }

    private void loadRelLineShape(Element relEle, IRelationship rel) throws InterruptedException {
        this.checkInterrupted();
        Element relShapeEle = MindManagerImporter.child(relEle, "ap:RelationshipLineShape");
        if (relShapeEle == null) {
            return;
        }
        String shape = MindManagerImporter.parseRelationshipShape(MindManagerImporter.att(relShapeEle, "LineShape"));
        this.registerStyle((IStyled)rel, "shape-class", shape);
    }

    private static String parseRelationshipShape(String shape) {
        return MindManagerImporter.getMapping("relationshipShape", shape, null);
    }

    private void loadConnections(Element relEle, IRelationship rel, boolean autoRouting) throws InterruptedException {
        this.checkInterrupted();
        Iterator<Element> it = MindManagerImporter.children(relEle, "ap:ConnectionGroup");
        while (it.hasNext()) {
            Element connGroupEle = it.next();
            this.loadRelConnection(connGroupEle, rel, autoRouting);
        }
    }

    private void loadRelConnection(Element connGroupEle, IRelationship rel, boolean autoRouting) throws InterruptedException {
        Element connStyleEle;
        this.checkInterrupted();
        int index = NumberUtils.safeParseInt((String)MindManagerImporter.att(connGroupEle, "Index"), (int)-1);
        if (index != 0 && index != 1) {
            return;
        }
        Element connEle = MindManagerImporter.child(connGroupEle, "ap:Connection");
        if (connEle == null) {
            return;
        }
        Element refEle = MindManagerImporter.child(connEle, "ap:ObjectReference");
        if (refEle == null) {
            return;
        }
        String oIdRef = MindManagerImporter.att(refEle, "OIdRef");
        String endId = this.idMap.get(oIdRef);
        if (endId == null) {
            return;
        }
        if (index == 0) {
            rel.setEnd1Id(endId);
        } else {
            rel.setEnd2Id(endId);
        }
        if (!autoRouting || connEle != null) {
            String cx = MindManagerImporter.att(connEle, "CX");
            String cy = MindManagerImporter.att(connEle, "CY");
            if (cx != null && cy != null) {
                Float x = MindManagerImporter.parseFloat(cx);
                Float y = MindManagerImporter.parseFloat(cy);
                if (x != null && y != null) {
                    rel.getControlPoint(index).setPosition(MindManagerImporter.mm2Dots(x.floatValue()), MindManagerImporter.mm2Dots(y.floatValue()));
                }
            }
        }
        if ((connStyleEle = MindManagerImporter.child(connGroupEle, "ap:ConnectionStyle")) != null) {
            String arrowShape = MindManagerImporter.parseConnShape(MindManagerImporter.att(connStyleEle, "ConnectionShape"));
            String styleKey = index == 0 ? "arrow-begin-class" : "arrow-end-class";
            this.registerStyle((IStyled)rel, styleKey, arrowShape);
        }
    }

    private static String parseConnShape(String shape) {
        return MindManagerImporter.getMapping("arrowShape", shape, null);
    }

    private boolean loadAutoRouting(Element relEle) throws InterruptedException {
        this.checkInterrupted();
        Element autoRouteEle = MindManagerImporter.child(relEle, "ap:AutoRoute");
        if (autoRouteEle != null) {
            return Boolean.parseBoolean(MindManagerImporter.att(autoRouteEle, "AutoRouting"));
        }
        return false;
    }

    private void loadRootTopic(Element oneTopicEle) throws InterruptedException {
        this.checkInterrupted();
        Element topicEle = MindManagerImporter.child(oneTopicEle, "Topic");
        if (topicEle != null) {
            this.loadTopicContent(topicEle, this.getTargetSheet().getRootTopic());
        }
    }

    private void loadTopicContent(Element topicEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        this.loadOId(topicEle, (IIdentifiable)topic);
        this.loadTitle(topicEle, (ITitled)topic);
        this.loadColor(topicEle, (IStyled)topic, false);
        this.loadPosition(topicEle, topic);
        this.loadTopicViewGroup(topicEle, topic);
        this.loadImage(topicEle, topic);
        this.loadTopicShape(topicEle, topic);
        this.loadHyperlink(topicEle, topic);
        this.loadMarkers(topicEle, topic);
        this.loadLabels(topicEle, topic);
        this.loadNotes(topicEle, topic);
        this.loadTask(topicEle, topic);
        this.loadNumbering(topicEle, topic);
        this.loadSubTopics(topicEle, topic);
        this.loadDetachedSubTopics(topicEle, topic);
        this.loadBoundary(topicEle, topic);
        this.loadStructure(topicEle, topic);
        this.loadAttachments(topicEle, topic);
    }

    private void loadAttachments(Element topicEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        Element attGroupEle = MindManagerImporter.child(topicEle, "ap:AttachmentGroup");
        if (attGroupEle == null) {
            return;
        }
        Iterator<Element> it = MindManagerImporter.children(attGroupEle, "ap:AttachmentData");
        while (it.hasNext()) {
            String name;
            String oId;
            IFileEntry entry;
            Element attDataEle = it.next();
            String uri = MindManagerImporter.loadUri(attDataEle);
            if (uri == null || (entry = this.loadAttachment(oId = MindManagerImporter.att(attDataEle, "AttachmentId"), uri, name = MindManagerImporter.att(attDataEle, "FileName"))) == null) continue;
            if (name == null) {
                name = new File(entry.getPath()).getName();
            }
            ITopic attTopic = this.getTargetWorkbook().createTopic();
            attTopic.setTitleText(name);
            attTopic.setHyperlink(HyperlinkUtils.toAttachmentURL((String)entry.getPath()));
            topic.add(attTopic, "attached");
        }
    }

    private void loadStructure(Element topicEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        Element subTopicsShapeEle = MindManagerImporter.child(topicEle, "ap:SubTopicsShape");
        if (subTopicsShapeEle == null) {
            return;
        }
        String line = MindManagerImporter.parseBranchConnection(MindManagerImporter.att(subTopicsShapeEle, "SubTopicsConnectionStyle"));
        this.registerStyle((IStyled)topic, "line-class", line);
        String structureClass = MindManagerImporter.parseStructureType(subTopicsShapeEle);
        topic.setStructureClass(structureClass);
    }

    private static String parseStructureType(Element ele) {
        String align = MindManagerImporter.att(ele, "SubTopicsAlignment");
        String growth = MindManagerImporter.att(ele, "SubTopicsGrowth");
        String growthDir = MindManagerImporter.att(ele, "SubTopicsGrowthDirection");
        if ("urn:mindjet:Center".equals(align) && "urn:mindjet:Horizontal".equals(growth)) {
            if ("urn:mindjet:LeftAndRight".equals(growthDir)) {
                return "org.xmind.ui.map.clockwise";
            }
            if ("urn:mindjet:Right".equals(growthDir)) {
                return "org.xmind.ui.logic.right";
            }
            if ("urn:mindjet:Left".equals(growthDir)) {
                return "org.xmind.ui.logic.left";
            }
        } else if ("urn:mindjet:Vertical".equals(growth) && "urn:mindjet:Middle".equals(MindManagerImporter.att(ele, "SubTopicsVerticalAlignment"))) {
            String vgd = MindManagerImporter.att(ele, "SubTopicsVerticalGrowthDirection");
            if ("urn:mindjet:Down".equals(vgd) || "urn:mindjet:UpAndDown".equals(vgd)) {
                return "org.xmind.ui.org-chart.down";
            }
            if ("urn:mindjet:Up".equals(vgd)) {
                return "org.xmind.ui.org-chart.up";
            }
        } else if ("urn:mindjet:Bottom".equals(align) && "urn:mindjet:Horizontal".equals(growth)) {
            if ("urn:mindjet:Right".equals(growthDir) || "urn:mindjet:LeftAndRight".equals(growthDir)) {
                return "org.xmind.ui.tree.right";
            }
            if ("urn:mindjet:Left".equals(growthDir)) {
                return "org.xmind.ui.tree.left";
            }
        }
        return null;
    }

    private static String parseBranchConnection(String lineShape) {
        return MindManagerImporter.getMapping("branchConnection", lineShape, null);
    }

    private void loadBoundary(Element topicEle, ITopic topic) throws InterruptedException {
        IBoundary boundary;
        IBoundary range;
        int index;
        ITopic parent;
        ISummary summary;
        this.checkInterrupted();
        if (topic.isRoot()) {
            return;
        }
        Element oneBoundaryEle = MindManagerImporter.child(topicEle, "ap:OneBoundary");
        if (oneBoundaryEle == null) {
            return;
        }
        Element boundaryEle = MindManagerImporter.child(oneBoundaryEle, "ap:Boundary");
        if (boundaryEle == null) {
            return;
        }
        this.checkInterrupted();
        String boundaryShape = this.getBoundaryShape(boundaryEle);
        String shape = MindManagerImporter.parseSummaryShape(boundaryShape);
        if (shape != null && topic.isAttached()) {
            summary = this.getTargetWorkbook().createSummary();
            parent = topic.getParent();
            index = topic.getIndex();
            summary.setStartIndex(index);
            summary.setEndIndex(index);
            parent.addSummary(summary);
            range = summary;
        } else {
            shape = MindManagerImporter.parseBoundaryShape(boundaryShape);
            boundary = this.getTargetWorkbook().createBoundary();
            if (topic.isAttached()) {
                parent = topic.getParent();
                index = topic.getIndex();
                boundary.setStartIndex(index);
                boundary.setEndIndex(index);
                parent.addBoundary(boundary);
            } else {
                parent = null;
                boundary.setMasterBoundary(true);
                topic.addBoundary(boundary);
            }
            range = boundary;
        }
        this.loadOId(boundaryEle, (IIdentifiable)range);
        this.loadColor(boundaryEle, (IStyled)range, true);
        this.loadLineStyle(boundaryEle, (IStyled)range);
        this.registerStyle((IStyled)range, "shape-class", shape);
        if (range instanceof ISummary && parent != null) {
            summary = (ISummary)range;
            ITopic summaryTopic = this.getTargetWorkbook().createTopic();
            parent.add(summaryTopic, "summary");
            summary.setTopicId(summaryTopic.getId());
            Element summaryTopicEle = this.getSummaryTopicEle(boundaryEle);
            if (summaryTopicEle != null) {
                this.loadTopicContent(summaryTopicEle, summaryTopic);
            } else {
                summaryTopic.setTitleText(" ");
                this.registerStyle((IStyled)summaryTopic, "shape-class", "org.xmind.topicShape.noBorder");
            }
        } else if (range instanceof IBoundary) {
            boundary = range;
            Element boundaryTopicEle = this.getSummaryTopicEle(boundaryEle);
            if (boundaryTopicEle != null) {
                this.loadTitle(boundaryTopicEle, (ITitled)boundary);
            }
        }
    }

    private Element getSummaryTopicEle(Element boundaryEle) {
        Element oneSummaryTopicEle = MindManagerImporter.child(boundaryEle, "ap:OneSummaryTopic");
        if (oneSummaryTopicEle != null) {
            return MindManagerImporter.child(oneSummaryTopicEle, "ap:Topic");
        }
        return null;
    }

    private String getBoundaryShape(Element boundaryEle) {
        Element shapeEle = MindManagerImporter.child(boundaryEle, "ap:BoundaryShape");
        if (shapeEle != null) {
            return MindManagerImporter.att(shapeEle, "BoundaryShape");
        }
        return null;
    }

    private static String parseBoundaryShape(String shape) {
        return MindManagerImporter.getMapping("boundaryShape", shape, null);
    }

    private static String parseSummaryShape(String shape) {
        return MindManagerImporter.getMapping("summaryShape", shape, null);
    }

    private void loadLineStyle(Element parentEle, IStyled host) throws InterruptedException {
        Element lineStyleEle;
        String color;
        this.checkInterrupted();
        Element lineColor = MindManagerImporter.child(parentEle, "ap:Color");
        if (lineColor != null && (color = MindManagerImporter.att(lineColor, "LineColor")) != null) {
            this.registerStyle(host, "line-color", "#" + color.substring(2));
        }
        if ((lineStyleEle = MindManagerImporter.child(parentEle, "ap:LineStyle")) == null) {
            return;
        }
        String linePattern = MindManagerImporter.parseLinePattern(MindManagerImporter.att(lineStyleEle, "LineDashStyle"));
        this.registerStyle(host, "line-pattern", linePattern);
        String width = MindManagerImporter.parseLineWidth(MindManagerImporter.att(lineStyleEle, "LineWidth"));
        this.registerStyle(host, "line-width", width);
    }

    private static String parseLineWidth(String width) {
        Float w = MindManagerImporter.parseFloat(width);
        if (w != null) {
            if ((double)w.floatValue() <= 1.0) {
                return "1";
            }
            if ((double)w.floatValue() <= 2.25) {
                return "2";
            }
            if ((double)w.floatValue() <= 3.0) {
                return "3";
            }
            if ((double)w.floatValue() <= 4.5) {
                return "4";
            }
            return "5";
        }
        return null;
    }

    private static String parseLinePattern(String dashStyle) {
        return MindManagerImporter.getMapping("lineStyle", dashStyle, null);
    }

    private void loadDetachedSubTopics(Element topicEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        Element subTopicsEle = MindManagerImporter.child(topicEle, "ap:FloatingTopics");
        if (subTopicsEle != null) {
            Iterator<Element> it = MindManagerImporter.children(subTopicsEle, "ap:Topic");
            while (it.hasNext()) {
                Element subTopicEle = it.next();
                ITopic subTopic = this.getTargetWorkbook().createTopic();
                Element item = MindManagerImporter.child(subTopicEle, "ap:Offset");
                if (item != null && item.hasAttribute("OffsetPriority")) {
                    topic.add(subTopic, "detached");
                } else {
                    topic.add(subTopic, "callout");
                }
                this.loadTopicContent(subTopicEle, subTopic);
            }
        }
    }

    private void loadSubTopics(Element topicEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        Element subTopicsEle = MindManagerImporter.child(topicEle, "ap:SubTopics");
        if (subTopicsEle != null) {
            Iterator<Element> it = MindManagerImporter.children(subTopicsEle, "ap:Topic");
            while (it.hasNext()) {
                Element subTopicEle = it.next();
                ITopic subTopic = this.getTargetWorkbook().createTopic();
                topic.add(subTopic, "attached");
                this.loadTopicContent(subTopicEle, subTopic);
            }
        }
    }

    private void loadNumbering(Element topicEle, ITopic topic) {
        Element numberingEle = this.findNumberingEle(topicEle, topic);
        if (numberingEle == null) {
            return;
        }
        int maxDepth = this.getMaxDepth(numberingEle);
        int topicDepth = this.getTopicDepth(topic);
        String numberFormat = this.getNumberFormat(numberingEle, topicDepth);
        if (numberFormat == null) {
            return;
        }
        String prefix = this.getNumberingPrefix(numberingEle, topicDepth);
        INumbering numbering = topic.getNumbering();
        if (maxDepth - topicDepth >= 0) {
            numbering.setFormat(numberFormat);
        } else {
            numbering.setFormat(NUMBER_FORMAT_NONE);
        }
        if (topicDepth == 1) {
            numbering.setPrependsParentNumbers(false);
        }
        numbering.setPrefix(prefix);
    }

    private String getNumberFormat(Element numberingEle, int depth) {
        String numbering = MindManagerImporter.att(numberingEle, "cst1:Numbering");
        if (numbering == null) {
            return null;
        }
        int formatIndex = (depth - 1) * 2;
        if (formatIndex < 0 || formatIndex + 1 > numbering.length()) {
            return NUMBER_FORMAT_NONE;
        }
        String numberFormat = numbering.substring(formatIndex, formatIndex + 1);
        if ("1".equals(numberFormat)) {
            return NUMBER_FORMAT_ARABIC;
        }
        if ("I".equals(numberFormat) || "i".equals(numberFormat)) {
            return NUMBER_FORMAT_ROMAN;
        }
        if ("A".equals(numberFormat)) {
            return NUMBER_FORMAT_UPPERCASE;
        }
        if ("a".equals(numberFormat)) {
            return NUMBER_FORMAT_LOWERCASE;
        }
        return NUMBER_FORMAT_NONE;
    }

    private String getNumberingPrefix(Element numberingEle, int topicDepth) {
        String preFix = MindManagerImporter.att(numberingEle, "cst0:Level" + topicDepth + "Text");
        return preFix == null ? "" : preFix;
    }

    private int getMaxDepth(Element numberingEle) {
        String depth = MindManagerImporter.att(numberingEle, "cst1:Depth");
        return Integer.parseInt(depth == null ? "1" : depth);
    }

    private int getTopicDepth(ITopic topic) {
        if (this.numberingEles == null) {
            return 0;
        }
        int topicDepth = 1;
        while (topic != null) {
            Element numberingEle = this.numberingEles.get(topic);
            if (numberingEle != null) {
                return topicDepth;
            }
            topic = topic.getParent();
            ++topicDepth;
        }
        return 0;
    }

    private Element findNumberingEle(Element topicEle, ITopic topic) {
        if (topicEle == null) {
            return null;
        }
        Element numberingEle = MindManagerImporter.child(topicEle, "cor:Custom");
        if (numberingEle != null) {
            if (this.numberingEles == null) {
                this.numberingEles = new HashMap<ITopic, Element>();
            }
            this.numberingEles.put(topic, numberingEle);
            return numberingEle;
        }
        return this.findParentNumbering(topic);
    }

    private Element findParentNumbering(ITopic topic) {
        if (this.numberingEles == null) {
            return null;
        }
        int topicDepth = 1;
        while (topic.getParent() != null) {
            Element numberingEle = this.numberingEles.get(topic = topic.getParent());
            if (numberingEle != null && this.getMaxDepth(numberingEle) >= topicDepth) {
                return numberingEle;
            }
            ++topicDepth;
        }
        return null;
    }

    private void loadNotes(Element topicEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        Element notesGroupEle = MindManagerImporter.child(topicEle, "ap:NotesGroup");
        if (notesGroupEle == null) {
            return;
        }
        Element notesXhtmlDataEle = MindManagerImporter.child(notesGroupEle, "ap:NotesXhtmlData");
        if (notesXhtmlDataEle != null) {
            Element htmlEle;
            String bookmarks = this.getBookmarks(topicEle, topic);
            String plain = MindManagerImporter.att(notesXhtmlDataEle, "PreviewPlainText");
            if (plain != null) {
                IPlainNotesContent content = (IPlainNotesContent)this.getTargetWorkbook().createNotesContent("plain");
                content.setTextContent(String.valueOf(bookmarks) + plain);
                topic.getNotes().setContent("plain", (INotesContent)content);
            }
            if ((htmlEle = MindManagerImporter.child(notesXhtmlDataEle, "xhtml:html")) != null) {
                IHtmlNotesContent content = (IHtmlNotesContent)this.getTargetWorkbook().createNotesContent("html");
                this.loadHtmlNotes(notesGroupEle, htmlEle, content, bookmarks);
                topic.getNotes().setContent("html", (INotesContent)content);
            }
        }
    }

    private void loadHtmlNotes(Element notesGroupEle, Element htmlEle, IHtmlNotesContent content, String bookmarks) throws InterruptedException {
        NotesImporter notesImporter = new NotesImporter(content);
        notesImporter.addText(bookmarks);
        notesImporter.loadFrom(notesGroupEle, htmlEle);
    }

    private void loadImageAtt(String imgUri, String uri) throws InterruptedException {
        this.checkInterrupted();
        this.loadAttachment(null, uri, "*.png");
    }

    private String getBookmarks(Element topicEle, ITopic topic) {
        Element bookmarkEle = MindManagerImporter.child(topicEle, "ap:Bookmark");
        if (bookmarkEle == null) {
            return "";
        }
        String bookmarkName = MindManagerImporter.att(bookmarkEle, "Name");
        if (bookmarkName != null) {
            return String.valueOf(bookmarkName) + '\r';
        }
        return "";
    }

    private void loadLabels(Element topicEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        Element labelsEle = MindManagerImporter.child(topicEle, "ap:TextLabels");
        if (labelsEle == null) {
            return;
        }
        Iterator<Element> it = MindManagerImporter.children(labelsEle, "ap:TextLabel");
        while (it.hasNext()) {
            this.checkInterrupted();
            String label = MindManagerImporter.att(it.next(), "TextLabelName");
            if (label == null) continue;
            topic.addLabel(label);
        }
    }

    private void loadMarkers(Element topicEle, ITopic topic) throws InterruptedException {
        Element iconsEle;
        Element iconsGroupEle;
        this.checkInterrupted();
        Element taskEle = MindManagerImporter.child(topicEle, "ap:Task");
        if (taskEle != null) {
            this.addMarker(topic, MindManagerImporter.att(taskEle, "TaskPriority"));
            this.addMarker(topic, MindManagerImporter.att(taskEle, "TaskPercentage"));
        }
        if ((iconsGroupEle = MindManagerImporter.child(topicEle, "ap:IconsGroup")) != null && (iconsEle = MindManagerImporter.child(iconsGroupEle, "ap:Icons")) != null) {
            Iterator<Element> it = MindManagerImporter.children(iconsEle, "ap:Icon");
            while (it.hasNext()) {
                this.addMarker(topic, MindManagerImporter.att(it.next(), "IconType"));
            }
        }
    }

    private void addMarker(ITopic topic, String mmIconId) throws InterruptedException {
        String markerId;
        this.checkInterrupted();
        if (mmIconId != null && (markerId = MindManagerImporter.parseMarkerId(mmIconId)) != null) {
            topic.addMarker(markerId);
        }
    }

    private void addCheckPoint(ITopicExtensionElement content, String hasCheckPoint) {
        if (hasCheckPoint != null && hasCheckPoint.equals("true")) {
            content.setAttribute("check-point", "true");
        }
    }

    private static String parseMarkerId(String mmIconId) {
        return MindManagerImporter.getMapping("marker", mmIconId, "other-question");
    }

    private void loadHyperlink(Element topicEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        Element hyperlinkEle = MindManagerImporter.child(topicEle, "ap:Hyperlink");
        if (hyperlinkEle == null) {
            return;
        }
        String url = MindManagerImporter.att(hyperlinkEle, "Url");
        if (url != null) {
            if (url.startsWith("#xpointer(")) {
                Matcher m = MindManagerImporter.getOIdPattern().matcher(url);
                if (m.find()) {
                    String OId = m.group(1);
                    this.recordTopicLink(OId, topic);
                }
                return;
            }
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                String path = url.startsWith("\"") && url.endsWith("\"") ? url.substring(1, url.length() - 1) : url;
                String absolute = MindManagerImporter.att(hyperlinkEle, "Absolute");
                url = FilePathParser.toURI((String)path, (absolute != null && !Boolean.parseBoolean(absolute) ? 1 : 0) != 0);
            }
            topic.setHyperlink(url);
        }
    }

    private static Pattern getOIdPattern() {
        if (OID_PATTERN == null) {
            OID_PATTERN = Pattern.compile("@OId='([^']*)'");
        }
        return OID_PATTERN;
    }

    private void loadTopicShape(Element topicEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        Element shapeEle = MindManagerImporter.child(topicEle, "ap:SubTopicShape");
        if (shapeEle == null) {
            return;
        }
        String shape = MindManagerImporter.parseTopicShape(MindManagerImporter.att(shapeEle, "SubTopicShape"));
        this.registerStyle((IStyled)topic, "shape-class", shape);
    }

    private static String parseTopicShape(String shape) {
        return MindManagerImporter.getMapping("topicShape", shape, null);
    }

    private void loadImage(Element topicEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        Element oneImageEle = MindManagerImporter.child(topicEle, "ap:OneImage");
        if (oneImageEle == null) {
            return;
        }
        Element imageEle = MindManagerImporter.child(oneImageEle, "ap:Image");
        if (imageEle == null) {
            return;
        }
        String oId = MindManagerImporter.att(imageEle, "OId");
        Element imageDataEle = MindManagerImporter.child(imageEle, "ap:ImageData");
        if (imageDataEle == null) {
            return;
        }
        String uri = MindManagerImporter.loadUri(imageDataEle);
        IFileEntry imgEntry = this.loadAttachment(oId, uri, "*.png");
        if (imgEntry == null) {
            return;
        }
        IImage image = topic.getImage();
        image.setSource(HyperlinkUtils.toAttachmentURL((String)imgEntry.getPath()));
        Element sizeEle = MindManagerImporter.child(imageEle, "ap:ImageSize");
        if (sizeEle != null) {
            String width = MindManagerImporter.att(sizeEle, "Width");
            String height = MindManagerImporter.att(sizeEle, "Height");
            Float w = MindManagerImporter.parseFloat(width);
            Float h = MindManagerImporter.parseFloat(height);
            image.setSize(w == null ? -1 : MindManagerImporter.mm2Dots(w.floatValue()), h == null ? -1 : MindManagerImporter.mm2Dots(h.floatValue()));
        }
        String position = null;
        Element topicLayoutEle = MindManagerImporter.child(topicEle, "ap:TopicLayout");
        if (topicLayoutEle != null) {
            position = MindManagerImporter.att(topicLayoutEle, "TopicTextAndImagePosition");
        }
        image.setAlignment(MindManagerImporter.parseImageAlign(position));
    }

    private IFileEntry loadAttachment(String oId, String uri, String proposalName) throws InterruptedException {
        String path;
        block17: {
            this.checkInterrupted();
            if (uri == null) {
                return null;
            }
            if (this.idMap.containsKey(uri)) {
                String path2 = this.idMap.get(uri);
                if (path2 != null) {
                    return this.getTargetWorkbook().getManifest().getFileEntry(path2);
                }
                return null;
            }
            path = null;
            if (uri.startsWith("mmarch://")) {
                String mmEntryPath = uri.substring("mmarch://".length());
                InputStream mmEntryStream = this.tempSource.getEntryStream(mmEntryPath);
                if (mmEntryStream == null) {
                    return null;
                }
                if (proposalName != null && proposalName.startsWith("*.")) {
                    String ext = proposalName.substring(1);
                    String oldName = new File(mmEntryPath).getName();
                    proposalName = String.valueOf(FileUtils.getNoExtensionFileName((String)oldName)) + ext;
                }
                MonitoredInputStream in = new MonitoredInputStream(mmEntryStream, this.getMonitor());
                try {
                    try {
                        IFileEntry entry = this.getTargetWorkbook().getManifest().createAttachmentFromStream((InputStream)in, proposalName);
                        path = entry.getPath();
                    }
                    catch (IOException e) {
                        this.log(e, "Failed to create attachment from: " + mmEntryPath);
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.idMap.put(uri, path);
        return this.getTargetWorkbook().getManifest().getFileEntry(path);
    }

    private static String parseImageAlign(String position) {
        return MindManagerImporter.getMapping("imageAlignment", position, "right");
    }

    private static String loadUri(Element ele) {
        Element uriEle;
        if (ele != null && (uriEle = MindManagerImporter.child(ele, "cor:Uri")) != null) {
            return uriEle.getTextContent();
        }
        return null;
    }

    private void loadTopicViewGroup(Element topicEle, ITopic topic) throws InterruptedException {
        String c;
        Element collapsedEle;
        this.checkInterrupted();
        Element viewGroupEle = MindManagerImporter.child(topicEle, "ap:TopicViewGroup");
        if (viewGroupEle != null && (collapsedEle = MindManagerImporter.child(viewGroupEle, "ap:Collapsed")) != null && Boolean.parseBoolean(c = MindManagerImporter.att(collapsedEle, "Collapsed"))) {
            topic.setFolded(true);
        }
    }

    private void loadPosition(Element topicEle, ITopic topic) throws InterruptedException {
        this.checkInterrupted();
        Element offsetEle = MindManagerImporter.child(topicEle, "ap:Offset");
        if (offsetEle != null) {
            String cx = MindManagerImporter.att(offsetEle, "CX");
            String cy = MindManagerImporter.att(offsetEle, "CY");
            Float x = MindManagerImporter.parseFloat(cx);
            Float y = MindManagerImporter.parseFloat(cy);
            if (x != null && y != null && x.floatValue() != 0.0f && y.floatValue() != 0.0f) {
                topic.setPosition(MindManagerImporter.mm2Dots(x.floatValue()), MindManagerImporter.mm2Dots(y.floatValue()));
            }
        }
    }

    private static Float parseFloat(String value) {
        if (value != null) {
            try {
                return Float.valueOf(value);
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    private void loadTask(Element ownerEle, ITopic topic) throws InterruptedException {
        String durationHours;
        String resources;
        Matcher m;
        String endDate;
        Matcher m2;
        this.checkInterrupted();
        Element taskEle = MindManagerImporter.child(ownerEle, "ap:Task");
        if (taskEle == null) {
            return;
        }
        ITopicExtensionElement taskContent = null;
        String startDate = MindManagerImporter.att(taskEle, "StartDate");
        if (startDate != null && (m2 = DATE_PATTERN.matcher(startDate)).find()) {
            taskContent = MindManagerImporter.ensureTaskContent(topic, taskContent);
            taskContent.deleteChildren("start-date");
            ITopicExtensionElement ele = (ITopicExtensionElement)taskContent.createChild("start-date");
            ele.setTextContent(String.valueOf(m2.group(1)) + " " + m2.group(5));
        }
        if ((endDate = MindManagerImporter.att(taskEle, "DeadlineDate")) != null && (m = DATE_PATTERN.matcher(endDate)).find()) {
            taskContent = MindManagerImporter.ensureTaskContent(topic, taskContent);
            taskContent.deleteChildren("end-date");
            ITopicExtensionElement ele = (ITopicExtensionElement)taskContent.createChild("end-date");
            ele.setTextContent(String.valueOf(m.group(1)) + " " + m.group(5));
        }
        if ((resources = MindManagerImporter.att(taskEle, "Resources")) != null) {
            String[] resourceArray = resources.split("; ");
            taskContent = MindManagerImporter.ensureTaskContent(topic, taskContent);
            taskContent.deleteChildren("assigned-to");
            ITopicExtensionElement ele = (ITopicExtensionElement)taskContent.createChild("assigned-to");
            ele.setTextContent(resources);
            String[] stringArray = resourceArray;
            int n = resourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                String resource = stringArray[n2];
                topic.addLabel(NLS.bind((String)ImportMessages.MindManagerImporter_ResourceLabel, (Object)resource.replaceAll(",", ";")));
                ++n2;
            }
        }
        if ((durationHours = MindManagerImporter.att(taskEle, "DurationHours")) != null) {
            String durationLabel = null;
            String durationUnit = MindManagerImporter.att(taskEle, "DurationUnit");
            if (durationUnit != null) {
                try {
                    int hours = Integer.parseInt(durationHours);
                    if ("urn:mindjet:Month".equals(durationUnit)) {
                        durationLabel = NLS.bind((String)ImportMessages.MindManagerImporter_Months, (Object)(hours / 160));
                    } else if ("urn:mindjet:Week".equals(durationUnit)) {
                        durationLabel = NLS.bind((String)ImportMessages.MindManagerImporter_Weeks, (Object)(hours / 40));
                    } else if ("urn:mindjet:Day".equals(durationUnit)) {
                        durationLabel = NLS.bind((String)ImportMessages.MindManagerImporter_Days, (Object)(hours / 8));
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (durationLabel == null) {
                durationLabel = NLS.bind((String)ImportMessages.MindManagerImporter_Hours, (Object)durationHours);
            }
            topic.addLabel(NLS.bind((String)ImportMessages.MindManagerImporter_DurationLabel, (Object)durationLabel));
        }
        this.addCheckPoint(MindManagerImporter.ensureTaskContent(topic, taskContent), MindManagerImporter.att(taskEle, "Milestone"));
    }

    private static ITopicExtensionElement ensureTaskContent(ITopic topic, ITopicExtensionElement taskContent) {
        if (taskContent != null) {
            return taskContent;
        }
        ITopicExtension ext = topic.createExtension("org.xmind.ui.taskInfo");
        return ext.getContent();
    }

    private void loadTitle(Element ownerEle, ITitled titleOwner) throws InterruptedException {
        String title;
        this.checkInterrupted();
        Element textEle = MindManagerImporter.child(ownerEle, "ap:Text");
        String string = title = textEle == null ? null : MindManagerImporter.att(textEle, "PlainText");
        if (title == null && titleOwner instanceof ITopic) {
            title = ImporterUtils.getDefaultTopicTitle((ITopic)titleOwner);
        }
        if (title != null) {
            titleOwner.setTitleText(title);
        }
        if (textEle != null && titleOwner instanceof IStyled) {
            String align;
            Element fontEle = MindManagerImporter.child(textEle, "ap:Font");
            if (fontEle != null) {
                this.loadFont(fontEle, (IStyled)titleOwner);
            }
            String string2 = align = textEle == null ? null : MindManagerImporter.att(textEle, "TextAlignment");
            if (align != null) {
                this.loadTextAlignment(align, (IStyled)titleOwner);
            }
        }
    }

    private void loadTextAlignment(String align, IStyled styleOwner) {
        if (align.startsWith("urn:mindjet:")) {
            int len = "urn:mindjet:".length();
            String textAlign = align.substring(len).toLowerCase();
            this.registerStyle(styleOwner, "fo:text-align", textAlign);
        }
    }

    private void loadFont(Element fontEle, IStyled styleOwner) throws InterruptedException {
        this.checkInterrupted();
        this.registerStyle(styleOwner, "fo:color", MindManagerImporter.parseColor(MindManagerImporter.att(fontEle, "Color")));
        String fontName = MindManagerImporter.att(fontEle, "Name");
        String availableFontName = FontUtils.getAAvailableFontNameFor((String)fontName);
        fontName = availableFontName != null ? availableFontName : fontName;
        this.registerStyle(styleOwner, "fo:font-family", fontName);
        this.registerStyle(styleOwner, "fo:font-size", MindManagerImporter.parseFontSize(MindManagerImporter.att(fontEle, "Size")));
        this.registerStyle(styleOwner, "fo:font-weight", Boolean.parseBoolean(MindManagerImporter.att(fontEle, "Bold")) ? "bold" : null);
        this.registerStyle(styleOwner, "fo:font-style", Boolean.parseBoolean(MindManagerImporter.att(fontEle, "Italic")) ? "italic" : null);
        String textDecoration = StyleUtils.toTextDecoration((boolean)Boolean.parseBoolean(MindManagerImporter.att(fontEle, "Underline")), (boolean)Boolean.parseBoolean(MindManagerImporter.att(fontEle, "Strikethrough")));
        this.registerStyle(styleOwner, "fo:text-decoration", textDecoration);
    }

    private static String parseFontSize(String size) {
        if (size != null) {
            try {
                double value = Double.parseDouble(size);
                size = StyleUtils.addUnitPoint((int)((int)value));
            }
            catch (Throwable throwable) {}
        }
        return size;
    }

    private void loadColor(Element parentEle, IStyled host, boolean transparent) throws InterruptedException {
        this.checkInterrupted();
        Element colorEle = MindManagerImporter.child(parentEle, "ap:Color");
        if (colorEle != null) {
            String fillColor = MindManagerImporter.att(colorEle, "FillColor");
            String opacity = MindManagerImporter.parseAlpha(fillColor);
            if (opacity != null && !opacity.equals(TRANSPARENT_VALUE)) {
                this.registerStyle(host, "svg:fill", MindManagerImporter.parseColor(fillColor));
            }
            if (transparent) {
                this.registerStyle(host, "svg:opacity", opacity);
            }
            String lineColor = MindManagerImporter.att(colorEle, "LineColor");
            this.registerStyle(host, "line-color", MindManagerImporter.parseColor(lineColor));
        }
    }

    private IStyleSheet getTempStyleSheet() {
        if (this.tempStyleSheet == null) {
            this.tempStyleSheet = Core.getStyleSheetBuilder().createStyleSheet();
            ((StyleSheetImpl)this.tempStyleSheet).setManifest(this.getTargetWorkbook().getManifest());
        }
        return this.tempStyleSheet;
    }

    private void registerStyle(IStyled styleOwner, String key, String value) {
        String oldValue;
        if (value == null) {
            return;
        }
        IStyle style = this.styleMap.get(styleOwner);
        if (style == null) {
            style = this.getTempStyleSheet().createStyle(styleOwner.getStyleType());
            this.getTempStyleSheet().addStyle(style, "normal-styles");
            this.styleMap.put(styleOwner, style);
        }
        if ("fo:text-decoration".equals(key) && (oldValue = style.getProperty(key)) != null && !oldValue.contains(value)) {
            boolean underline = oldValue.contains("underline") || value.contains("underline");
            boolean strikeout = oldValue.contains("line-through") || value.contains("line-through");
            value = StyleUtils.toTextDecoration((boolean)underline, (boolean)strikeout);
        }
        style.setProperty(key, value);
    }

    private static String parseAlpha(String mmColor) {
        if (mmColor != null) {
            try {
                int alpha = Integer.parseInt(mmColor.substring(0, 1), 16);
                double opacity = (double)alpha * 100.0 / 255.0;
                return String.format("%.2f", opacity);
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    private static String parseColor(String mmColor) {
        if (mmColor != null) {
            try {
                int r = Integer.parseInt(mmColor.substring(2, 4), 16);
                int g = Integer.parseInt(mmColor.substring(4, 6), 16);
                int b = Integer.parseInt(mmColor.substring(6, 8), 16);
                return ColorUtils.toString((int)r, (int)g, (int)b);
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    private void loadOId(Element mmEle, IIdentifiable element) {
        String OId = MindManagerImporter.att(mmEle, "OId");
        if (OId != null) {
            this.idMap.put(OId, element.getId());
        }
    }

    private void recordTopicLink(String OId, ITopic sourceTopic) {
        List<ITopic> topics = this.topicLinkMap.get(OId);
        if (topics == null) {
            topics = new ArrayList<ITopic>();
            this.topicLinkMap.put(OId, topics);
        }
        topics.add(sourceTopic);
    }

    private void setTopicLinks() {
        for (Map.Entry<String, List<ITopic>> en : this.topicLinkMap.entrySet()) {
            String id = this.idMap.get(en.getKey());
            if (id == null) continue;
            for (ITopic topic : en.getValue()) {
                topic.setHyperlink(HyperlinkUtils.toInternalURL((String)id));
            }
        }
    }

    private static Element child(Element parentEle, String childTag) {
        return MindManagerImporter.children(parentEle, childTag).next();
    }

    private static Iterator<Element> children(Element parentEle, String childTag) {
        return new Iterator<Element>(childTag, parentEle){
            String tag;
            Iterator<Element> it;
            Element next;
            {
                this.tag = DOMUtils.getLocalName((String)string);
                this.it = DOMUtils.childElementIter((Node)element);
                this.next = this.findNext();
            }

            @Override
            public void remove() {
            }

            private Element findNext() {
                while (this.it.hasNext()) {
                    Element ele = this.it.next();
                    if (!DOMUtils.getLocalName((String)ele.getTagName()).equalsIgnoreCase(this.tag)) continue;
                    return ele;
                }
                return null;
            }

            @Override
            public Element next() {
                Element result = this.next;
                this.next = this.findNext();
                return result;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }
        };
    }

    private static String att(Element ele, String attName) {
        if (ele.hasAttribute(attName)) {
            return ele.getAttribute(attName);
        }
        attName = DOMUtils.getLocalName((String)attName);
        NamedNodeMap atts = ele.getAttributes();
        int i = 0;
        while (i < atts.getLength()) {
            Node att = atts.item(i);
            if (attName.equalsIgnoreCase(DOMUtils.getLocalName((String)att.getNodeName()))) {
                return att.getNodeValue();
            }
            ++i;
        }
        return null;
    }

    private static int mm2Dots(float mm) {
        return (int)((double)mm * 2.834645669291339);
    }

    private static String getMapping(String type, String sourceId, String defaultId) {
        String destination;
        if (sourceId != null && (destination = MindManagerImporter.getMappings().getDestination(type, sourceId)) != null) {
            return destination;
        }
        return defaultId;
    }

    private static ResourceMappingManager getMappings() {
        if (mappings == null) {
            mappings = MindManagerImporter.createMappings();
        }
        return mappings;
    }

    private static ResourceMappingManager createMappings() {
        return MMResourceMappingManager.getInstance();
    }

    private static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return DOMUtils.getDefaultDocumentBuilder();
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.log(exception, null);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.log(exception, null);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.log(exception, null);
    }

    private class NotesImporter {
        IParagraph currentParagraph = null;
        Stack<IStyle> styleStack = new Stack();
        IHtmlNotesContent content;

        public NotesImporter(IHtmlNotesContent content) {
            this.content = content;
        }

        public void loadFrom(Element notesGroupEle, Element element) throws InterruptedException {
            MindManagerImporter.this.checkInterrupted();
            String tagName = DOMUtils.getLocalName((String)element.getTagName());
            if ("br".equalsIgnoreCase(tagName)) {
                this.addParagraph();
                return;
            }
            boolean isParagraph = "p".equalsIgnoreCase(tagName) || "li".equalsIgnoreCase(tagName);
            IStyle style = this.pushStyle(element, isParagraph ? "paragraph" : "text");
            if (isParagraph) {
                this.addParagraph();
            } else if ("img".equalsIgnoreCase(tagName)) {
                this.addImage(notesGroupEle, element);
            }
            NodeList nl = element.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node node = nl.item(i);
                short nodeType = node.getNodeType();
                if (nodeType == 3) {
                    this.addText(node.getTextContent());
                } else if (nodeType == 1) {
                    this.loadFrom(notesGroupEle, (Element)node);
                }
                ++i;
            }
            this.popStyle(style);
        }

        private void addText(String text) {
            if (text == null) {
                return;
            }
            if ("".equals(text = text.trim())) {
                return;
            }
            this.addSpan((ISpan)this.content.createTextSpan(text));
        }

        private void addImage(Element notesGroupEle, Element imgEle) throws InterruptedException {
            Iterator it = MindManagerImporter.children(notesGroupEle, "ap:NotesData");
            while (it.hasNext()) {
                String entryPath;
                Element notesDataEle = (Element)it.next();
                String imgUri = MindManagerImporter.att(notesDataEle, "ImageUri");
                String sourceImg = MindManagerImporter.att(imgEle, "src");
                if (imgUri == null || sourceImg == null || !imgUri.equals(sourceImg)) continue;
                MindManagerImporter.this.loadImageAtt(imgUri, MindManagerImporter.loadUri(notesDataEle));
                String srcUrl = MindManagerImporter.loadUri(notesDataEle);
                if (srcUrl == null || (entryPath = (String)MindManagerImporter.this.idMap.get(srcUrl)) == null) continue;
                this.addSpan((ISpan)this.content.createImageSpan(HyperlinkUtils.toAttachmentPath((String)entryPath)));
            }
        }

        private void addSpan(ISpan span) {
            if (this.currentParagraph == null) {
                this.addParagraph();
            }
            this.currentParagraph.addSpan(span);
            if (!(span instanceof IImageSpan)) {
                this.registerStyle((IStyled)span, "fo:font-family", "fo:font-size", "fo:color", "fo:font-weight", "fo:text-decoration", "fo:font-style");
            }
        }

        private void addParagraph() {
            this.currentParagraph = this.content.createParagraph();
            this.content.addParagraph(this.currentParagraph);
            this.registerStyle((IStyled)this.currentParagraph, "fo:text-align");
        }

        private void registerStyle(IStyled host, String ... keys) {
            for (IStyle style : this.styleStack) {
                this.registerStyle(host, style, keys);
            }
        }

        private void registerStyle(IStyled host, IStyle style, String ... keys) {
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String value = style.getProperty(key);
                if (value != null) {
                    MindManagerImporter.this.registerStyle(host, key, value);
                }
                ++n2;
            }
        }

        private IStyle pushStyle(Element ele, String type) {
            IStyle style = MindManagerImporter.this.getTempStyleSheet().createStyle(type);
            this.receiveStyle(ele, style);
            if (style.isEmpty()) {
                style = null;
            } else {
                this.styleStack.push(style);
            }
            return style;
        }

        private void receiveStyle(Element ele, IStyle style) {
            String name;
            String align = this.parseAlign(MindManagerImporter.att(ele, "align"));
            if (align != null) {
                style.setProperty("fo:text-align", align);
            }
            if ("b".equalsIgnoreCase(name = ele.getTagName())) {
                style.setProperty("fo:font-weight", "bold");
            } else if ("i".equalsIgnoreCase(name)) {
                style.setProperty("fo:font-style", "italic");
            } else if ("u".equalsIgnoreCase(name)) {
                style.setProperty("fo:text-decoration", "underline");
            } else if ("s".equalsIgnoreCase(name)) {
                style.setProperty("fo:text-decoration", "line-through");
            } else if ("font".equalsIgnoreCase(name)) {
                String fontName = MindManagerImporter.att(ele, "face");
                String availableFontName = FontUtils.getAAvailableFontNameFor((String)fontName);
                String string = fontName = availableFontName != null ? availableFontName : fontName;
                if (fontName != null) {
                    style.setProperty("fo:font-family", fontName);
                }
            } else if ("span".equalsIgnoreCase(name) && "font".equalsIgnoreCase(((Element)ele.getParentNode()).getTagName())) {
                String color = MindManagerImporter.att((Element)ele.getParentNode(), "color");
                style.setProperty("fo:color", color);
            }
            String styleContent = MindManagerImporter.att(ele, "style");
            if (styleContent != null) {
                this.receiveStyleContent(style, styleContent);
            }
        }

        private String parseAlign(String align) {
            if (align != null && ("center".equalsIgnoreCase(align) || "left".equalsIgnoreCase(align) || "right".equalsIgnoreCase(align))) {
                return align;
            }
            return null;
        }

        private void receiveStyleContent(IStyle style, String styleContent) {
            String[] items;
            String[] stringArray = items = styleContent.trim().split(";");
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                int colonIndex = (item = item.trim()).indexOf(58);
                if (colonIndex > 0) {
                    String key = item.substring(0, colonIndex).trim();
                    String value = item.substring(colonIndex + 1).trim();
                    this.receiveStyleItem(style, key, value);
                }
                ++n2;
            }
        }

        private void receiveStyleItem(IStyle style, String key, String value) {
            int fontSize;
            if ("color".equalsIgnoreCase(key)) {
                String color = this.parseColor(value);
                if (color != null) {
                    style.setProperty("fo:color", color);
                }
            } else if ("font-size".equalsIgnoreCase(key) && (fontSize = NumberUtils.safeParseInt((String)value, (int)-1)) > 0) {
                style.setProperty("fo:font-size", StyleUtils.addUnitPoint((int)fontSize));
            }
        }

        private void popStyle(IStyle style) {
            if (style == null) {
                return;
            }
            if (this.styleStack != null && this.styleStack.peek() == style) {
                this.styleStack.pop();
            }
        }

        private String parseColor(String color) {
            return color;
        }
    }
}

