/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.list;

import com.lowagie.text.ListItem;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.list.RtfList;
import com.lowagie.text.rtf.text.RtfChunk;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfListItem
extends RtfParagraph {
    private RtfList parentList = null;
    private boolean containsInnerList = false;

    public RtfListItem(RtfDocument doc, ListItem listItem) {
        super(doc, listItem);
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            for (int i = 0; i < this.chunks.size(); ++i) {
                RtfBasicElement rtfElement = (RtfBasicElement)this.chunks.get(i);
                if (rtfElement instanceof RtfChunk) {
                    ((RtfChunk)rtfElement).setSoftLineBreaks(true);
                } else if (rtfElement instanceof RtfList) {
                    result.write(RtfParagraph.PARAGRAPH);
                    this.containsInnerList = true;
                }
                result.write(rtfElement.write());
                if (!(rtfElement instanceof RtfList)) continue;
                result.write(this.parentList.writeListBeginning());
                result.write("\\tab".getBytes());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] writeDefinition() {
        for (int i = 0; i < this.chunks.size(); ++i) {
            RtfBasicElement rtfElement = (RtfBasicElement)this.chunks.get(i);
            if (!(rtfElement instanceof RtfList)) continue;
            return ((RtfList)rtfElement).writeDefinition();
        }
        return new byte[0];
    }

    public void inheritListSettings(int listNumber, int listLevel) {
        for (int i = 0; i < this.chunks.size(); ++i) {
            RtfBasicElement rtfElement = (RtfBasicElement)this.chunks.get(i);
            if (!(rtfElement instanceof RtfList)) continue;
            ((RtfList)rtfElement).setListNumber(listNumber);
            ((RtfList)rtfElement).setListLevel(listLevel);
            ((RtfList)rtfElement).setParent(this.parentList);
        }
    }

    protected void correctIndentation() {
        for (int i = 0; i < this.chunks.size(); ++i) {
            RtfBasicElement rtfElement = (RtfBasicElement)this.chunks.get(i);
            if (!(rtfElement instanceof RtfList)) continue;
            ((RtfList)rtfElement).correctIndentation();
        }
    }

    public void setParent(RtfList parentList) {
        this.parentList = parentList;
    }

    public boolean isContainsInnerList() {
        return this.containsInnerList;
    }
}

